/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.springframework.messaging.Message;

public final class KafkaUtils {
    public static boolean returnTypeMessageOrCollectionOf(Method method) {
        Type returnType = method.getGenericReturnType();
        if (returnType.equals(Message.class)) {
            return true;
        }
        if (returnType instanceof ParameterizedType) {
            ParameterizedType prt = (ParameterizedType)returnType;
            Type rawType = prt.getRawType();
            if (rawType.equals(Message.class)) {
                return true;
            }
            if (rawType.equals(Collection.class)) {
                Type collectionType = prt.getActualTypeArguments()[0];
                if (collectionType.equals(Message.class)) {
                    return true;
                }
                return collectionType instanceof ParameterizedType && ((ParameterizedType)collectionType).getRawType().equals(Message.class);
            }
        }
        return false;
    }

    private KafkaUtils() {
    }
}

