/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.kafka.support.LogIfLevelEnabled;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContainerProperties {
    public static final long DEFAULT_POLL_TIMEOUT = 5000L;
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 10000L;
    public static final int DEFAULT_MONITOR_INTERVAL = 30;
    public static final float DEFAULT_NO_POLL_THRESHOLD = 3.0f;
    private final String[] topics;
    private final Pattern topicPattern;
    private final TopicPartitionInitialOffset[] topicPartitions;
    private AckMode ackMode = AckMode.BATCH;
    private int ackCount;
    private long ackTime;
    private Object messageListener;
    private volatile long pollTimeout = 5000L;
    private AsyncListenableTaskExecutor consumerTaskExecutor;
    private long shutdownTimeout = 10000L;
    private ConsumerRebalanceListener consumerRebalanceListener;
    private OffsetCommitCallback commitCallback;
    private boolean syncCommits = true;
    private Duration syncCommitTimeout;
    private boolean ackOnError = false;
    private Long idleEventInterval;
    private String groupId;
    private PlatformTransactionManager transactionManager;
    private int monitorInterval = 30;
    private TaskScheduler scheduler;
    private float noPollThreshold = 3.0f;
    private String clientId = "";
    private boolean logContainerConfig;
    private LogIfLevelEnabled.Level commitLogLevel = LogIfLevelEnabled.Level.DEBUG;
    private boolean missingTopicsFatal = true;
    private Properties consumerProperties = new Properties();

    public ContainerProperties(String ... topics) {
        Assert.notEmpty((Object[])topics, (String)"An array of topics must be provided");
        this.topics = (String[])topics.clone();
        this.topicPattern = null;
        this.topicPartitions = null;
    }

    public ContainerProperties(Pattern topicPattern) {
        this.topics = null;
        this.topicPattern = topicPattern;
        this.topicPartitions = null;
    }

    public ContainerProperties(TopicPartitionInitialOffset ... topicPartitions) {
        this.topics = null;
        this.topicPattern = null;
        Assert.notEmpty((Object[])topicPartitions, (String)"An array of topicPartitions must be provided");
        this.topicPartitions = new LinkedHashSet<TopicPartitionInitialOffset>(Arrays.asList(topicPartitions)).toArray(new TopicPartitionInitialOffset[topicPartitions.length]);
    }

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"'ackMode' cannot be null");
        this.ackMode = ackMode;
    }

    public void setPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public void setAckCount(int count) {
        Assert.state((count > 0 ? 1 : 0) != 0, (String)"'ackCount' must be > 0");
        this.ackCount = count;
    }

    public void setAckTime(long ackTime) {
        Assert.state((ackTime > 0L ? 1 : 0) != 0, (String)"'ackTime' must be > 0");
        this.ackTime = ackTime;
    }

    public void setConsumerTaskExecutor(AsyncListenableTaskExecutor consumerTaskExecutor) {
        this.consumerTaskExecutor = consumerTaskExecutor;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setConsumerRebalanceListener(ConsumerRebalanceListener consumerRebalanceListener) {
        this.consumerRebalanceListener = consumerRebalanceListener;
    }

    public void setCommitCallback(OffsetCommitCallback commitCallback) {
        this.commitCallback = commitCallback;
    }

    public void setSyncCommits(boolean syncCommits) {
        this.syncCommits = syncCommits;
    }

    public void setSyncCommitTimeout(@Nullable Duration syncCommitTimeout) {
        this.syncCommitTimeout = syncCommitTimeout;
    }

    public void setIdleEventInterval(Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setAckOnError(boolean ackOnError) {
        this.ackOnError = ackOnError;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public Pattern getTopicPattern() {
        return this.topicPattern;
    }

    public TopicPartitionInitialOffset[] getTopicPartitions() {
        return this.topicPartitions;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public int getAckCount() {
        return this.ackCount;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public AsyncListenableTaskExecutor getConsumerTaskExecutor() {
        return this.consumerTaskExecutor;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public ConsumerRebalanceListener getConsumerRebalanceListener() {
        return this.consumerRebalanceListener;
    }

    public OffsetCommitCallback getCommitCallback() {
        return this.commitCallback;
    }

    public boolean isSyncCommits() {
        return this.syncCommits;
    }

    public Duration getSyncCommitTimeout() {
        return this.syncCommitTimeout;
    }

    public Long getIdleEventInterval() {
        return this.idleEventInterval;
    }

    public boolean isAckOnError() {
        return this.ackOnError && !AckMode.MANUAL_IMMEDIATE.equals((Object)this.ackMode) && !AckMode.MANUAL.equals((Object)this.ackMode);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public float getNoPollThreshold() {
        return this.noPollThreshold;
    }

    public void setNoPollThreshold(float noPollThreshold) {
        this.noPollThreshold = noPollThreshold;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isLogContainerConfig() {
        return this.logContainerConfig;
    }

    public void setLogContainerConfig(boolean logContainerConfig) {
        this.logContainerConfig = logContainerConfig;
    }

    public LogIfLevelEnabled.Level getCommitLogLevel() {
        return this.commitLogLevel;
    }

    public void setCommitLogLevel(LogIfLevelEnabled.Level commitLogLevel) {
        Assert.notNull((Object)((Object)commitLogLevel), (String)"'commitLogLevel' cannot be nul");
        this.commitLogLevel = commitLogLevel;
    }

    public boolean isMissingTopicsFatal() {
        return this.missingTopicsFatal;
    }

    public void setMissingTopicsFatal(boolean missingTopicsFatal) {
        this.missingTopicsFatal = missingTopicsFatal;
    }

    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(Properties consumerProperties) {
        Assert.notNull((Object)consumerProperties, (String)"'consumerProperties' cannot be null");
        this.consumerProperties = consumerProperties;
    }

    public String toString() {
        return "ContainerProperties [" + this.renderTopics() + ", ackMode=" + (Object)((Object)this.ackMode) + ", ackCount=" + this.ackCount + ", ackTime=" + this.ackTime + ", messageListener=" + this.messageListener + ", pollTimeout=" + this.pollTimeout + (this.consumerTaskExecutor != null ? ", consumerTaskExecutor=" + this.consumerTaskExecutor : "") + ", shutdownTimeout=" + this.shutdownTimeout + (this.consumerRebalanceListener != null ? ", consumerRebalanceListener=" + this.consumerRebalanceListener : "") + (this.commitCallback != null ? ", commitCallback=" + this.commitCallback : "") + ", syncCommits=" + this.syncCommits + (this.syncCommitTimeout != null ? ", syncCommitTimeout=" + this.syncCommitTimeout : "") + ", ackOnError=" + this.ackOnError + ", idleEventInterval=" + (this.idleEventInterval == null ? "not enabled" : this.idleEventInterval) + (this.groupId != null ? ", groupId=" + this.groupId : "") + (this.transactionManager != null ? ", transactionManager=" + this.transactionManager : "") + ", monitorInterval=" + this.monitorInterval + (this.scheduler != null ? ", scheduler=" + this.scheduler : "") + ", noPollThreshold=" + this.noPollThreshold + (StringUtils.hasText((String)this.clientId) ? ", clientId=" + this.clientId : "") + "]";
    }

    private String renderTopics() {
        return (this.topics != null ? "topics=" + Arrays.toString(this.topics) : "") + (this.topicPattern != null ? ", topicPattern=" + this.topicPattern : "") + (this.topicPartitions != null ? ", topicPartitions=" + Arrays.toString(this.topicPartitions) : "");
    }

    public static enum AckMode {
        RECORD,
        BATCH,
        TIME,
        COUNT,
        COUNT_TIME,
        MANUAL,
        MANUAL_IMMEDIATE;

    }
}

