/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.kafka.support.converter.AbstractJavaTypeMapper;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JsonDeserializer<T>
implements Deserializer<T> {
    private static final String KEY_DEFAULT_TYPE_STRING = "spring.json.key.default.type";
    private static final String DEPRECATED_DEFAULT_VALUE_TYPE = "spring.json.default.value.type";
    @Deprecated
    public static final String DEFAULT_KEY_TYPE = "spring.json.key.default.type";
    @Deprecated
    public static final String DEFAULT_VALUE_TYPE = "spring.json.default.value.type";
    public static final String KEY_DEFAULT_TYPE = "spring.json.key.default.type";
    public static final String VALUE_DEFAULT_TYPE = "spring.json.value.default.type";
    public static final String TRUSTED_PACKAGES = "spring.json.trusted.packages";
    public static final String TYPE_MAPPINGS = "spring.json.type.mapping";
    public static final String REMOVE_TYPE_INFO_HEADERS = "spring.json.remove.type.headers";
    public static final String USE_TYPE_INFO_HEADERS = "spring.json.use.type.headers";
    protected final ObjectMapper objectMapper;
    protected JavaType targetType;
    protected Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();
    private volatile ObjectReader reader;
    private boolean typeMapperExplicitlySet = false;
    private boolean removeTypeHeaders = true;

    public JsonDeserializer() {
        this((Class)null, true);
    }

    public JsonDeserializer(ObjectMapper objectMapper) {
        this((Class)null, objectMapper, true);
    }

    public JsonDeserializer(Class<? super T> targetType) {
        this(targetType, true);
    }

    public JsonDeserializer(TypeReference<? super T> targetType) {
        this(targetType, true);
    }

    public JsonDeserializer(@Nullable Class<? super T> targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonUtils.enhancedObjectMapper(), useHeadersIfPresent);
    }

    public JsonDeserializer(TypeReference<? super T> targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonUtils.enhancedObjectMapper(), useHeadersIfPresent);
    }

    public JsonDeserializer(Class<? super T> targetType, ObjectMapper objectMapper) {
        this(targetType, objectMapper, true);
    }

    public JsonDeserializer(TypeReference<? super T> targetType, ObjectMapper objectMapper) {
        this(targetType, objectMapper, true);
    }

    public JsonDeserializer(@Nullable Class<? super T> targetType, ObjectMapper objectMapper, boolean useHeadersIfPresent) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
        JavaType javaType = null;
        if (targetType == null) {
            Class genericType = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0});
            if (genericType != null) {
                javaType = TypeFactory.defaultInstance().constructType((Type)genericType);
            }
        } else {
            javaType = TypeFactory.defaultInstance().constructType(targetType);
        }
        this.initialize(javaType, useHeadersIfPresent);
    }

    public JsonDeserializer(TypeReference<? super T> targetType, ObjectMapper objectMapper, boolean useHeadersIfPresent) {
        this(targetType != null ? TypeFactory.defaultInstance().constructType(targetType) : null, objectMapper, useHeadersIfPresent);
    }

    public JsonDeserializer(@Nullable JavaType targetType, ObjectMapper objectMapper, boolean useHeadersIfPresent) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
        this.initialize(targetType, useHeadersIfPresent);
    }

    private void initialize(@Nullable JavaType type, boolean useHeadersIfPresent) {
        this.targetType = type;
        Assert.isTrue((this.targetType != null || useHeadersIfPresent ? 1 : 0) != 0, (String)"'targetType' cannot be null if 'useHeadersIfPresent' is false");
        if (this.targetType != null) {
            this.reader = this.objectMapper.readerFor(this.targetType);
        }
        this.addTargetPackageToTrusted();
        this.typeMapper.setTypePrecedence(useHeadersIfPresent ? Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID : Jackson2JavaTypeMapper.TypePrecedence.INFERRED);
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
        this.typeMapperExplicitlySet = true;
    }

    public void setUseTypeMapperForKey(boolean isKey) {
        if (!this.typeMapperExplicitlySet && this.getTypeMapper() instanceof AbstractJavaTypeMapper) {
            ((AbstractJavaTypeMapper)((Object)this.getTypeMapper())).setUseForKey(isKey);
        }
    }

    public void setRemoveTypeHeaders(boolean removeTypeHeaders) {
        this.removeTypeHeaders = removeTypeHeaders;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.setUseTypeMapperForKey(isKey);
        this.setUpTypePrecedence(configs);
        this.setupTarget(configs, isKey);
        if (configs.containsKey(TRUSTED_PACKAGES) && configs.get(TRUSTED_PACKAGES) instanceof String) {
            this.typeMapper.addTrustedPackages(StringUtils.commaDelimitedListToStringArray((String)((String)configs.get(TRUSTED_PACKAGES))));
        }
        if (configs.containsKey(TYPE_MAPPINGS) && !this.typeMapperExplicitlySet && this.typeMapper instanceof AbstractJavaTypeMapper) {
            ((AbstractJavaTypeMapper)((Object)this.typeMapper)).setIdClassMapping(JsonSerializer.createMappings(configs.get(TYPE_MAPPINGS).toString()));
        }
        if (configs.containsKey(REMOVE_TYPE_INFO_HEADERS)) {
            this.removeTypeHeaders = Boolean.parseBoolean(configs.get(REMOVE_TYPE_INFO_HEADERS).toString());
        }
    }

    private void setUpTypePrecedence(Map<String, ?> configs) {
        if (!this.typeMapperExplicitlySet) {
            boolean useTypeHeaders = true;
            if (configs.containsKey(USE_TYPE_INFO_HEADERS)) {
                useTypeHeaders = Boolean.parseBoolean(configs.get(USE_TYPE_INFO_HEADERS).toString());
            }
            this.typeMapper.setTypePrecedence(useTypeHeaders ? Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID : Jackson2JavaTypeMapper.TypePrecedence.INFERRED);
        }
    }

    private void setupTarget(Map<String, ?> configs, boolean isKey) {
        try {
            JavaType javaType = null;
            if (isKey && configs.containsKey("spring.json.key.default.type")) {
                javaType = this.setupTargetType(configs, "spring.json.key.default.type");
            } else if (!isKey && configs.containsKey("spring.json.default.value.type")) {
                javaType = this.setupTargetType(configs, "spring.json.default.value.type");
            } else if (!isKey && configs.containsKey(VALUE_DEFAULT_TYPE)) {
                javaType = this.setupTargetType(configs, VALUE_DEFAULT_TYPE);
            }
            if (javaType != null) {
                this.initialize(javaType, Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID.equals((Object)this.typeMapper.getTypePrecedence()));
            }
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
    }

    private JavaType setupTargetType(Map<String, ?> configs, String key) throws ClassNotFoundException, LinkageError {
        if (configs.get(key) instanceof Class) {
            return TypeFactory.defaultInstance().constructType((Type)((Class)configs.get(key)));
        }
        if (configs.get(key) instanceof String) {
            return TypeFactory.defaultInstance().constructType((Type)ClassUtils.forName((String)((String)configs.get(key)), null));
        }
        throw new IllegalStateException(key + " must be Class or String");
    }

    public void addTrustedPackages(String ... packages) {
        this.doAddTrustedPackages(packages);
    }

    private void addTargetPackageToTrusted() {
        String targetPackageName = this.getTargetPackageName();
        if (targetPackageName != null) {
            this.doAddTrustedPackages(targetPackageName);
        }
    }

    private String getTargetPackageName() {
        if (this.targetType != null) {
            return ClassUtils.getPackageName((Class)this.targetType.getRawClass()).replaceFirst("\\[L", "");
        }
        return null;
    }

    private void doAddTrustedPackages(String ... packages) {
        this.typeMapper.addTrustedPackages(packages);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        JavaType javaType;
        if (data == null) {
            return null;
        }
        ObjectReader deserReader = null;
        if (this.typeMapper.getTypePrecedence().equals((Object)Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID) && (javaType = this.typeMapper.toJavaType(headers)) != null) {
            deserReader = this.objectMapper.readerFor(javaType);
        }
        if (this.removeTypeHeaders) {
            this.typeMapper.removeHeaders(headers);
        }
        if (deserReader == null) {
            deserReader = this.reader;
        }
        Assert.state((deserReader != null ? 1 : 0) != 0, (String)"No type information in headers and no default type provided");
        try {
            return (T)deserReader.readValue(data);
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public T deserialize(String topic, @Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        Assert.state((this.reader != null ? 1 : 0) != 0, (String)"No headers available and no default type provided");
        try {
            return (T)this.reader.readValue(data);
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public void close() {
    }
}

