/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.transaction;

import org.springframework.data.transaction.ChainedTransactionManager;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class ChainedKafkaTransactionManager<K, V>
extends ChainedTransactionManager
implements KafkaAwareTransactionManager<K, V> {
    private final KafkaAwareTransactionManager<K, V> kafkaTransactionManager;

    public ChainedKafkaTransactionManager(PlatformTransactionManager ... transactionManagers) {
        super(transactionManagers);
        KafkaAwareTransactionManager uniqueKafkaTransactionManager = null;
        for (PlatformTransactionManager tm : transactionManagers) {
            if (!(tm instanceof KafkaAwareTransactionManager)) continue;
            Assert.isNull(uniqueKafkaTransactionManager, (String)"Only one KafkaAwareTransactionManager is allowed");
            uniqueKafkaTransactionManager = (KafkaAwareTransactionManager)tm;
        }
        Assert.notNull(uniqueKafkaTransactionManager, (String)"Exactly one KafkaAwareTransactionManager is required");
        this.kafkaTransactionManager = uniqueKafkaTransactionManager;
    }

    @Override
    public ProducerFactory<K, V> getProducerFactory() {
        return this.kafkaTransactionManager.getProducerFactory();
    }
}

