/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.lang.Nullable;

public interface KafkaConsumerBackoffManager {
    public void backOffIfNecessary(Context var1);

    default public Context createContext(long dueTimestamp, String listenerId, TopicPartition topicPartition, @Nullable Consumer<?, ?> messageConsumer) {
        return new Context(dueTimestamp, topicPartition, listenerId, messageConsumer);
    }

    public static class Context {
        private final long dueTimestamp;
        private final String listenerId;
        private final TopicPartition topicPartition;
        private final Consumer<?, ?> consumerForTimingAdjustment;

        Context(long dueTimestamp, TopicPartition topicPartition, String listenerId, @Nullable Consumer<?, ?> consumerForTimingAdjustment) {
            this.dueTimestamp = dueTimestamp;
            this.listenerId = listenerId;
            this.topicPartition = topicPartition;
            this.consumerForTimingAdjustment = consumerForTimingAdjustment;
        }

        public long getDueTimestamp() {
            return this.dueTimestamp;
        }

        public String getListenerId() {
            return this.listenerId;
        }

        public TopicPartition getTopicPartition() {
            return this.topicPartition;
        }

        @Nullable
        public Consumer<?, ?> getConsumerForTimingAdjustment() {
            return this.consumerForTimingAdjustment;
        }
    }
}

