/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.annotation.AbstractPulsarAnnotationsBeanPostProcessor;
import org.springframework.pulsar.annotation.PulsarListener;
import org.springframework.pulsar.annotation.PulsarListenerConfigurer;
import org.springframework.pulsar.annotation.PulsarListenerConsumerBuilderCustomizer;
import org.springframework.pulsar.annotation.PulsarListeners;
import org.springframework.pulsar.config.MethodPulsarListenerEndpoint;
import org.springframework.pulsar.config.PulsarListenerContainerFactory;
import org.springframework.pulsar.config.PulsarListenerEndpointRegistrar;
import org.springframework.pulsar.config.PulsarListenerEndpointRegistry;
import org.springframework.pulsar.listener.PulsarConsumerErrorHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PulsarListenerAnnotationBeanPostProcessor<V>
extends AbstractPulsarAnnotationsBeanPostProcessor
implements SmartInitializingSingleton {
    public static final String DEFAULT_PULSAR_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "pulsarListenerContainerFactory";
    private static final String GENERATED_ID_PREFIX = "org.springframework.Pulsar.PulsarListenerEndpointContainer#";
    private PulsarListenerEndpointRegistry endpointRegistry;
    private String defaultContainerFactoryBeanName = "pulsarListenerContainerFactory";
    private final PulsarListenerEndpointRegistrar registrar = new PulsarListenerEndpointRegistrar(PulsarListenerContainerFactory.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final AbstractPulsarAnnotationsBeanPostProcessor.ListenerScope listenerScope = new AbstractPulsarAnnotationsBeanPostProcessor.ListenerScope();
    private final AtomicInteger counter = new AtomicInteger();
    private final List<MethodPulsarListenerEndpoint<?>> processedEndpoints = new ArrayList();

    public void afterSingletonsInstantiated() {
        this.registrar.setBeanFactory(this.beanFactory);
        this.beanFactory.getBeanProvider(PulsarListenerConfigurer.class).forEach(c -> c.configurePulsarListeners(this.registrar));
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (PulsarListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.pulsar.config.internalPulsarListenerEndpointRegistry", PulsarListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        this.addFormatters((FormatterRegistry)this.messageHandlerMethodFactory.defaultFormattingConversionService);
        this.postProcessEndpointsBeforeRegistration();
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set<PulsarListener> listenerMethods = this.findListenerAnnotations(method);
                return !listenerMethods.isEmpty() ? listenerMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                this.logger.trace(() -> "No @PulsarListener annotations found on bean type: " + String.valueOf(bean.getClass()));
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method2 = (Method)entry.getKey();
                    for (PulsarListener listener : (Set)entry.getValue()) {
                        this.processPulsarListener(listener, method2, bean, beanName);
                    }
                }
                this.logger.debug(() -> annotatedMethods.size() + " @PulsarListener methods processed on bean '" + beanName + "': " + String.valueOf(annotatedMethods));
            }
        }
        return bean;
    }

    protected void processPulsarListener(PulsarListener pulsarListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodPulsarListenerEndpoint endpoint = new MethodPulsarListenerEndpoint();
        endpoint.setMethod(methodToUse);
        String beanRef = pulsarListener.beanRef();
        this.listenerScope.addListener(beanRef, bean);
        String[] topics = this.resolveTopics(pulsarListener);
        String topicPattern = this.getTopicPattern(pulsarListener);
        this.processListener(endpoint, pulsarListener, bean, beanName, topics, topicPattern);
        this.listenerScope.removeListener(beanRef);
    }

    protected void processListener(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener PulsarListener2, Object bean, String beanName, String[] topics, String topicPattern) {
        this.processPulsarListenerAnnotation(endpoint, PulsarListener2, bean, topics, topicPattern);
        String containerFactory = this.resolve(PulsarListener2.containerFactory());
        PulsarListenerContainerFactory listenerContainerFactory = this.resolveContainerFactory(PulsarListener2, containerFactory, beanName);
        this.registrar.registerEndpoint(endpoint, listenerContainerFactory);
    }

    @Nullable
    private PulsarListenerContainerFactory resolveContainerFactory(PulsarListener PulsarListener2, Object factoryTarget, String beanName) {
        String containerFactory = PulsarListener2.containerFactory();
        if (!StringUtils.hasText((String)containerFactory)) {
            return null;
        }
        PulsarListenerContainerFactory factory = null;
        Object resolved = this.resolveExpression(containerFactory);
        if (resolved instanceof PulsarListenerContainerFactory) {
            return (PulsarListenerContainerFactory)resolved;
        }
        String containerFactoryBeanName = this.resolveExpressionAsString(containerFactory, "containerFactory");
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            this.assertBeanFactory();
            try {
                factory = (PulsarListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, PulsarListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(factoryTarget, beanName, containerFactoryBeanName, PulsarListenerContainerFactory.class), (Throwable)ex);
            }
        }
        return factory;
    }

    private void processPulsarListenerAnnotation(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener, Object bean, String[] topics, String topicPattern) {
        String autoStartup;
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setSubscriptionName(this.getEndpointSubscriptionName(pulsarListener));
        endpoint.setId(this.getEndpointId(pulsarListener));
        endpoint.setTopics(topics);
        endpoint.setTopicPattern(topicPattern);
        this.resolveSubscriptionType(endpoint, pulsarListener);
        endpoint.setSchemaType(pulsarListener.schemaType());
        endpoint.setAckMode(pulsarListener.ackMode());
        String concurrency = pulsarListener.concurrency();
        if (StringUtils.hasText((String)concurrency)) {
            endpoint.setConcurrency(this.resolveExpressionAsInteger(concurrency, "concurrency"));
        }
        if (StringUtils.hasText((String)(autoStartup = pulsarListener.autoStartup()))) {
            endpoint.setAutoStartup(this.resolveExpressionAsBoolean(autoStartup, "autoStartup"));
        }
        this.resolvePulsarProperties(endpoint, pulsarListener.properties());
        endpoint.setBatchListener(pulsarListener.batch());
        endpoint.setBeanFactory(this.beanFactory);
        this.resolveNegativeAckRedeliveryBackoff(endpoint, pulsarListener);
        this.resolveAckTimeoutRedeliveryBackoff(endpoint, pulsarListener);
        this.resolveDeadLetterPolicy(endpoint, pulsarListener);
        this.resolvePulsarConsumerErrorHandler(endpoint, pulsarListener);
        this.resolveConsumerCustomizer(endpoint, pulsarListener);
        String transactional = pulsarListener.transactional();
        if (StringUtils.hasText((String)transactional)) {
            endpoint.setTransactional(this.resolveExpressionAsBoolean(transactional, "transactional"));
        }
        this.processedEndpoints.add(endpoint);
    }

    private void resolveSubscriptionType(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Assert.state((pulsarListener.subscriptionType().length <= 1 ? 1 : 0) != 0, () -> "PulsarListener.subscriptionType must have 0 or 1 elements");
        if (pulsarListener.subscriptionType().length == 1) {
            endpoint.setSubscriptionType(pulsarListener.subscriptionType()[0]);
        }
    }

    private void resolvePulsarConsumerErrorHandler(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object pulsarConsumerErrorHandler = this.resolveExpression(pulsarListener.pulsarConsumerErrorHandler());
        if (pulsarConsumerErrorHandler instanceof PulsarConsumerErrorHandler) {
            endpoint.setPulsarConsumerErrorHandler((PulsarConsumerErrorHandler)pulsarConsumerErrorHandler);
        } else {
            String pulsarConsumerErrorHandlerBeanName = this.resolveExpressionAsString(pulsarListener.pulsarConsumerErrorHandler(), "pulsarConsumerErrorHandler");
            if (StringUtils.hasText((String)pulsarConsumerErrorHandlerBeanName)) {
                endpoint.setPulsarConsumerErrorHandler((PulsarConsumerErrorHandler)this.beanFactory.getBean(pulsarConsumerErrorHandlerBeanName, PulsarConsumerErrorHandler.class));
            }
        }
    }

    protected void postProcessEndpointsBeforeRegistration() {
        if (this.processedEndpoints.size() == 1) {
            MethodPulsarListenerEndpoint<?> endpoint = this.processedEndpoints.get(0);
            if (endpoint.getConsumerBuilderCustomizer() != null) {
                return;
            }
            this.beanFactory.getBeanProvider(PulsarListenerConsumerBuilderCustomizer.class).ifUnique(customizer -> {
                this.logger.info(() -> String.format("Setting the only registered PulsarListenerConsumerBuilderCustomizer on the only registered @PulsarListener (%s)", endpoint.getId()));
                endpoint.setConsumerBuilderCustomizer(customizer::customize);
            });
        }
    }

    private void resolveConsumerCustomizer(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        if (!StringUtils.hasText((String)pulsarListener.consumerCustomizer())) {
            return;
        }
        Object consumerCustomizer = this.resolveExpression(pulsarListener.consumerCustomizer());
        if (consumerCustomizer instanceof PulsarListenerConsumerBuilderCustomizer) {
            PulsarListenerConsumerBuilderCustomizer customizer = (PulsarListenerConsumerBuilderCustomizer)consumerCustomizer;
            endpoint.setConsumerBuilderCustomizer(customizer::customize);
        } else {
            String customizerBeanName = this.resolveExpressionAsString(pulsarListener.consumerCustomizer(), "consumerCustomizer");
            if (StringUtils.hasText((String)customizerBeanName)) {
                PulsarListenerConsumerBuilderCustomizer customizer = (PulsarListenerConsumerBuilderCustomizer)this.beanFactory.getBean(customizerBeanName, PulsarListenerConsumerBuilderCustomizer.class);
                endpoint.setConsumerBuilderCustomizer(customizer::customize);
            }
        }
    }

    private void resolveNegativeAckRedeliveryBackoff(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object negativeAckRedeliveryBackoff = this.resolveExpression(pulsarListener.negativeAckRedeliveryBackoff());
        if (negativeAckRedeliveryBackoff instanceof RedeliveryBackoff) {
            endpoint.setNegativeAckRedeliveryBackoff((RedeliveryBackoff)negativeAckRedeliveryBackoff);
        } else {
            String negativeAckRedeliveryBackoffBeanName = this.resolveExpressionAsString(pulsarListener.negativeAckRedeliveryBackoff(), "negativeAckRedeliveryBackoff");
            if (StringUtils.hasText((String)negativeAckRedeliveryBackoffBeanName)) {
                endpoint.setNegativeAckRedeliveryBackoff((RedeliveryBackoff)this.beanFactory.getBean(negativeAckRedeliveryBackoffBeanName, RedeliveryBackoff.class));
            }
        }
    }

    private void resolveAckTimeoutRedeliveryBackoff(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object ackTimeoutRedeliveryBackoff = this.resolveExpression(pulsarListener.ackTimeoutRedeliveryBackoff());
        if (ackTimeoutRedeliveryBackoff instanceof RedeliveryBackoff) {
            endpoint.setAckTimeoutRedeliveryBackoff((RedeliveryBackoff)ackTimeoutRedeliveryBackoff);
        } else {
            String ackTimeoutRedeliveryBackoffBeanName = this.resolveExpressionAsString(pulsarListener.ackTimeoutRedeliveryBackoff(), "ackTimeoutRedeliveryBackoff");
            if (StringUtils.hasText((String)ackTimeoutRedeliveryBackoffBeanName)) {
                endpoint.setAckTimeoutRedeliveryBackoff((RedeliveryBackoff)this.beanFactory.getBean(ackTimeoutRedeliveryBackoffBeanName, RedeliveryBackoff.class));
            }
        }
    }

    private void resolveDeadLetterPolicy(MethodPulsarListenerEndpoint<?> endpoint, PulsarListener pulsarListener) {
        Object deadLetterPolicy = this.resolveExpression(pulsarListener.deadLetterPolicy());
        if (deadLetterPolicy instanceof DeadLetterPolicy) {
            endpoint.setDeadLetterPolicy((DeadLetterPolicy)deadLetterPolicy);
        } else {
            String deadLetterPolicyBeanName = this.resolveExpressionAsString(pulsarListener.deadLetterPolicy(), "deadLetterPolicy");
            if (StringUtils.hasText((String)deadLetterPolicyBeanName)) {
                endpoint.setDeadLetterPolicy((DeadLetterPolicy)this.beanFactory.getBean(deadLetterPolicyBeanName, DeadLetterPolicy.class));
            }
        }
    }

    private void resolvePulsarProperties(MethodPulsarListenerEndpoint<?> endpoint, String[] propertyStrings) {
        if (propertyStrings.length > 0) {
            Properties properties = new Properties();
            for (String property : propertyStrings) {
                Object value = this.resolveExpression(property);
                if (value instanceof String) {
                    this.loadProperty(properties, property, value);
                    continue;
                }
                if (value instanceof String[]) {
                    for (String prop : (String[])value) {
                        this.loadProperty(properties, prop, prop);
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    Collection values = (Collection)value;
                    if (values.size() <= 0 || !(values.iterator().next() instanceof String)) continue;
                    for (String prop : (Collection)value) {
                        this.loadProperty(properties, prop, prop);
                    }
                    continue;
                }
                throw new IllegalStateException("'properties' must resolve to a String, a String[] or Collection<String>");
            }
            endpoint.setConsumerProperties(properties);
        }
    }

    private String getEndpointSubscriptionName(PulsarListener pulsarListener) {
        if (StringUtils.hasText((String)pulsarListener.subscriptionName())) {
            return this.resolveExpressionAsString(pulsarListener.subscriptionName(), "subscriptionName");
        }
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private String getEndpointId(PulsarListener pulsarListener) {
        if (StringUtils.hasText((String)pulsarListener.id())) {
            return this.resolveExpressionAsString(pulsarListener.id(), "id");
        }
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private String getTopicPattern(PulsarListener pulsarListener) {
        return this.resolveExpressionAsString(pulsarListener.topicPattern(), "topicPattern");
    }

    private String[] resolveTopics(PulsarListener PulsarListener2) {
        String[] topics = PulsarListener2.topics();
        ArrayList<String> result = new ArrayList<String>();
        if (topics.length > 0) {
            for (String topic1 : topics) {
                Object topic = this.resolveExpression(topic1);
                this.resolveAsString(topic, result);
            }
        }
        return result.toArray(new String[0]);
    }

    private Set<PulsarListener> findListenerAnnotations(Method method) {
        PulsarListeners anns;
        HashSet<PulsarListener> listeners = new HashSet<PulsarListener>();
        PulsarListener ann = (PulsarListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, PulsarListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        if ((anns = (PulsarListeners)AnnotationUtils.findAnnotation((Method)method, PulsarListeners.class)) != null) {
            listeners.addAll(Arrays.stream(anns.value()).toList());
        }
        return listeners;
    }

    private void addFormatters(FormatterRegistry registry) {
        this.beanFactory.getBeanProvider(Converter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(GenericConverter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
        this.beanFactory.getBeanProvider(Formatter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addFormatter(arg_0));
    }
}

