/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.pulsar.config.AbstractPulsarListenerContainerFactory;
import org.springframework.pulsar.config.PulsarListenerEndpoint;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.listener.AbstractPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.ConcurrentPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConcurrentPulsarListenerContainerFactory<T>
extends AbstractPulsarListenerContainerFactory<ConcurrentPulsarMessageListenerContainer<T>, T> {
    private Integer concurrency;

    public ConcurrentPulsarListenerContainerFactory(PulsarConsumerFactory<? super T> consumerFactory, PulsarContainerProperties containerProperties) {
        super(consumerFactory, containerProperties);
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public ConcurrentPulsarMessageListenerContainer<T> createContainer(final String ... topics) {
        PulsarListenerEndpoint endpoint = new PulsarListenerEndpoint(){

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        };
        AbstractPulsarMessageListenerContainer container = this.createContainerInstance(endpoint);
        this.initializeContainer((ConcurrentPulsarMessageListenerContainer<T>)container, endpoint);
        return container;
    }

    @Override
    protected ConcurrentPulsarMessageListenerContainer<T> createContainerInstance(PulsarListenerEndpoint endpoint) {
        PulsarContainerProperties properties = new PulsarContainerProperties(new String[0]);
        properties.setSchemaResolver(this.getContainerProperties().getSchemaResolver());
        properties.setTopicResolver(this.getContainerProperties().getTopicResolver());
        PulsarContainerProperties.TransactionSettings parentTxnProps = this.getContainerProperties().transactions();
        PulsarContainerProperties.TransactionSettings childTxnProps = properties.transactions();
        childTxnProps.setEnabled(parentTxnProps.isEnabled());
        childTxnProps.setRequired(parentTxnProps.isRequired());
        childTxnProps.setTimeout(parentTxnProps.getTimeout());
        childTxnProps.setTransactionDefinition(parentTxnProps.getTransactionDefinition());
        childTxnProps.setTransactionManager(parentTxnProps.getTransactionManager());
        if (!CollectionUtils.isEmpty(endpoint.getTopics())) {
            properties.setTopics(new HashSet<String>(endpoint.getTopics()));
        }
        if (StringUtils.hasText((String)endpoint.getTopicPattern())) {
            properties.setTopicsPattern(endpoint.getTopicPattern());
        }
        if (StringUtils.hasText((String)endpoint.getSubscriptionName())) {
            properties.setSubscriptionName(endpoint.getSubscriptionName());
        }
        if (endpoint.isBatchListener()) {
            properties.setBatchListener(endpoint.isBatchListener());
        }
        if (endpoint.getSubscriptionType() != null) {
            properties.setSubscriptionType(endpoint.getSubscriptionType());
        }
        properties.setSchemaType(endpoint.getSchemaType());
        return new ConcurrentPulsarMessageListenerContainer(this.getConsumerFactory(), properties);
    }

    @Override
    protected void initializeContainer(ConcurrentPulsarMessageListenerContainer<T> instance, PulsarListenerEndpoint endpoint) {
        super.initializeContainer(instance, endpoint);
        if (endpoint.getConcurrency() != null) {
            instance.setConcurrency(endpoint.getConcurrency());
        } else if (this.concurrency != null) {
            instance.setConcurrency(this.concurrency);
        }
    }
}

