/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Producer;
import org.springframework.core.log.LogAccessor;

final class ProducerUtils {
    private ProducerUtils() {
    }

    static <T> String formatProducer(Producer<T> producer) {
        return "(%s:%s)".formatted(producer.getProducerName(), producer.getTopic());
    }

    static <T> CompletableFuture<Void> closeProducerAsync(Producer<T> producer, LogAccessor logger) {
        return producer.closeAsync().exceptionally(e -> {
            logger.warn(e, () -> "Failed to close producer %s".formatted(ProducerUtils.formatProducer(producer)));
            return null;
        });
    }

    static <T> void closeProducer(Producer<T> producer, LogAccessor logger, Duration maxWaitTime) {
        try {
            producer.closeAsync().get(maxWaitTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn((Throwable)e, () -> "Failed to close producer %s".formatted(ProducerUtils.formatProducer(producer)));
        }
    }
}

