/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import org.apache.pulsar.common.naming.TopicDomain;
import org.springframework.pulsar.core.PulsarTopicBuilder;

public record PulsarTopic(String topicName, int numberOfPartitions) {
    public static PulsarTopicBuilder builder(String topicName) {
        return new PulsarTopicBuilder(topicName);
    }

    public boolean isPartitioned() {
        return this.numberOfPartitions != 0;
    }

    public TopicComponents getComponents() {
        String[] splitTopic = this.topicName().split("/");
        if (splitTopic.length == 1) {
            return new TopicComponents(TopicDomain.persistent, "public", "default", splitTopic[0]);
        }
        if (splitTopic.length == 3) {
            return new TopicComponents(TopicDomain.persistent, splitTopic[0], splitTopic[1], splitTopic[2]);
        }
        if (splitTopic.length == 5) {
            String type = splitTopic[0].replace(":", "");
            return new TopicComponents(TopicDomain.getEnum((String)type), splitTopic[2], splitTopic[3], splitTopic[4]);
        }
        throw new IllegalArgumentException("Topic name '" + String.valueOf(this) + "' has unexpected components.");
    }

    public String getFullyQualifiedTopicName() {
        TopicComponents components = this.getComponents();
        return String.valueOf(components.domain) + "://" + components.tenant + "/" + components.namespace + "/" + components.name;
    }

    record TopicComponents(TopicDomain domain, String tenant, String namespace, String name) {
    }
}

