/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.header;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pulsar.client.api.Message;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.pulsar.support.header.AbstractPulsarHeaderMapper;
import org.springframework.pulsar.support.header.JacksonUtils;
import org.springframework.util.ClassUtils;

public class JsonPulsarHeaderMapper
extends AbstractPulsarHeaderMapper<ToPulsarHeadersContext, ToSpringHeadersContext> {
    private static final Set<String> TRUSTED_ARRAY_TYPES = new HashSet<String>(Arrays.asList("[B", "[I", "[J", "[F", "[D", "[C"));
    private static final List<String> DEFAULT_TO_STRING_CLASSES = Arrays.asList("org.springframework.util.MimeType", "org.springframework.http.MediaType");
    public static final String JSON_TYPES = "spring_json_header_types";
    private final ObjectMapper objectMapper;
    private final Set<String> trustedPackages = new LinkedHashSet<String>();
    private final Set<String> toStringClasses = new LinkedHashSet<String>(DEFAULT_TO_STRING_CLASSES);

    JsonPulsarHeaderMapper(ObjectMapper objectMapper, List<String> inboundPatterns, List<String> outboundPatterns, Set<String> trustedPackages, Set<String> toStringClasses) {
        super(inboundPatterns, outboundPatterns);
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper must not be null");
        Objects.requireNonNull(trustedPackages, "trustedPackages must not be null");
        Objects.requireNonNull(toStringClasses, "toStringClasses must not be null");
        for (String trusted : trustedPackages) {
            if ("*".equals(trusted)) {
                this.trustedPackages.clear();
                break;
            }
            this.trustedPackages.add(trusted);
        }
        this.toStringClasses.addAll(toStringClasses);
    }

    public static JsonPulsarHeaderMapperBuilder builder() {
        return new JsonPulsarHeaderMapperBuilder();
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected Set<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    protected Set<String> getToStringClasses() {
        return this.toStringClasses;
    }

    @Override
    protected ToPulsarHeadersContext toPulsarHeadersOnStarted(MessageHeaders springHeaders) {
        LinkedHashMap<String, String> jsonHeaders = new LinkedHashMap<String, String>();
        return new ToPulsarHeadersContext(jsonHeaders);
    }

    @Override
    protected String toPulsarHeaderValue(String name, Object rawValue, ToPulsarHeadersContext context) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof String) {
            return (String)rawValue;
        }
        String className = rawValue.getClass().getName();
        if (this.toStringClasses.contains(className)) {
            return rawValue.toString();
        }
        try {
            String valueToAdd = this.getObjectMapper().writeValueAsString(rawValue);
            context.jsonTypes().put(name, className);
            return valueToAdd;
        }
        catch (Exception e) {
            this.logger.debug((Throwable)e, () -> "Could not map %s with type %s (will instead map w/ toString()) reason: %s".formatted(name, className, e.getMessage()));
            return rawValue.toString();
        }
    }

    @Override
    protected void toPulsarHeadersOnCompleted(MessageHeaders springHeaders, Map<String, String> pulsarHeaders, ToPulsarHeadersContext context) {
        Map<String, String> jsonHeaders = context.jsonTypes();
        if (jsonHeaders.size() > 0) {
            try {
                pulsarHeaders.put(JSON_TYPES, this.getObjectMapper().writeValueAsString(jsonHeaders));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, () -> "Could not add json types header due to: %s".formatted(e.getMessage()));
            }
        }
    }

    @Override
    protected boolean matchesForInbound(String header) {
        return !header.equals(JSON_TYPES) && super.matchesForInbound(header);
    }

    @Override
    @NonNull
    protected ToSpringHeadersContext toSpringHeadersOnStarted(Message<?> pulsarMessage) {
        Map<String, String> types = new HashMap<String, String>();
        if (pulsarMessage.hasProperty(JSON_TYPES)) {
            String jsonTypesStr = pulsarMessage.getProperty(JSON_TYPES);
            try {
                types = (Map)this.getObjectMapper().readValue(jsonTypesStr, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, () -> "Could not decode json types: %s due to: %s".formatted(jsonTypesStr, e.getMessage()));
            }
        }
        return new ToSpringHeadersContext(types);
    }

    @Override
    protected Object toSpringHeaderValue(String name, String value, ToSpringHeadersContext context) {
        Map<String, String> jsonTypes = context.jsonTypes();
        if (jsonTypes != null && jsonTypes.containsKey(name)) {
            String requestedType = jsonTypes.get(name);
            return this.toJsonHeaderValue(name, value, requestedType);
        }
        return value;
    }

    private Object toJsonHeaderValue(String name, String value, String requestedType) {
        Class type;
        if (!this.trusted(requestedType)) {
            return new NonTrustedHeaderType(value, requestedType);
        }
        try {
            type = ClassUtils.forName((String)requestedType, null);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, () -> "Could not load type (%s) for header (%s) due to: %s".formatted(requestedType, name, e.getMessage()));
            return value;
        }
        try {
            return this.decodeValue(name, value, type);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, () -> "Could not decode type (%s) for header (%s) using value (%s) due to: %s".formatted(type, name, value, e.getMessage()));
            return value;
        }
    }

    private Object decodeValue(String name, String value, Class<?> type) throws IOException {
        Object decodedValue = this.getObjectMapper().readValue(value, type);
        if (!type.equals(NonTrustedHeaderType.class)) {
            return decodedValue;
        }
        NonTrustedHeaderType nth = (NonTrustedHeaderType)decodedValue;
        if (!this.trusted(nth.untrustedType())) {
            return nth;
        }
        try {
            decodedValue = this.getObjectMapper().readValue(nth.headerValue(), ClassUtils.forName((String)nth.untrustedType(), null));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, () -> "Could not decode non-trusted header type (%s) for header (%s) using value (%s) due to: %s".formatted(nth.untrustedType(), name, nth.headerValue(), e.getMessage()));
        }
        return decodedValue;
    }

    protected boolean trusted(String requestedType) {
        if (requestedType.equals(NonTrustedHeaderType.class.getName())) {
            return true;
        }
        if (TRUSTED_ARRAY_TYPES.contains(requestedType)) {
            return true;
        }
        if (this.trustedPackages.isEmpty()) {
            return true;
        }
        String type = requestedType.startsWith("[") ? requestedType.substring(2) : requestedType;
        int lastDot = type.lastIndexOf(46);
        if (lastDot < 0) {
            return false;
        }
        String packageName = type.substring(0, lastDot);
        for (String trustedPackage : this.trustedPackages) {
            if (!packageName.equals(trustedPackage) && !packageName.startsWith(trustedPackage + ".")) continue;
            return true;
        }
        return false;
    }

    public static class JsonPulsarHeaderMapperBuilder {
        private ObjectMapper objectMapper;
        private final Set<String> trustedPackages = new HashSet<String>();
        private final Set<String> toStringClasses = new HashSet<String>();
        private final List<String> inboundPatterns = new ArrayList<String>();
        private final List<String> outboundPatterns = new ArrayList<String>();

        public JsonPulsarHeaderMapperBuilder objectMapper(@Nullable ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public JsonPulsarHeaderMapperBuilder trustedPackages(String ... packages) {
            this.trustedPackages.addAll(List.of(packages));
            return this;
        }

        public JsonPulsarHeaderMapperBuilder toStringClasses(String ... classNames) {
            this.toStringClasses.addAll(List.of(classNames));
            return this;
        }

        public JsonPulsarHeaderMapperBuilder inboundPatterns(String ... patterns) {
            this.inboundPatterns.addAll(List.of(patterns));
            return this;
        }

        public JsonPulsarHeaderMapperBuilder outboundPatterns(String ... patterns) {
            this.outboundPatterns.addAll(List.of(patterns));
            return this;
        }

        public JsonPulsarHeaderMapper build() {
            if (this.objectMapper == null) {
                this.objectMapper = JacksonUtils.enhancedObjectMapper();
            }
            return new JsonPulsarHeaderMapper(this.objectMapper, this.inboundPatterns, this.outboundPatterns, this.trustedPackages, this.toStringClasses);
        }
    }

    public record ToPulsarHeadersContext(Map<String, String> jsonTypes) {
    }

    public record ToSpringHeadersContext(Map<String, String> jsonTypes) {
    }

    public record NonTrustedHeaderType(String headerValue, String untrustedType) {
    }
}

