/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.classify;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.classify.Classifier;

public class SubclassClassifier<T, C>
implements Classifier<T, C> {
    private ConcurrentMap<Class<? extends T>, C> classified = new ConcurrentHashMap<Class<? extends T>, C>();
    private C defaultValue = null;

    public SubclassClassifier() {
        this(null);
    }

    public SubclassClassifier(C defaultValue) {
        this(new HashMap(), defaultValue);
    }

    public SubclassClassifier(Map<Class<? extends T>, C> typeMap, C defaultValue) {
        this.classified = new ConcurrentHashMap<Class<T>, C>(typeMap);
        this.defaultValue = defaultValue;
    }

    public void setDefaultValue(C defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTypeMap(Map<Class<? extends T>, C> map) {
        this.classified = new ConcurrentHashMap<Class<T>, C>(map);
    }

    @Override
    public C classify(T classifiable) {
        if (classifiable == null) {
            return this.defaultValue;
        }
        Class<?> exceptionClass = classifiable.getClass();
        if (this.classified.containsKey(exceptionClass)) {
            return (C)this.classified.get(exceptionClass);
        }
        TreeSet classes = new TreeSet(new ClassComparator());
        classes.addAll(this.classified.keySet());
        for (Class cls : classes) {
            if (!cls.isAssignableFrom(exceptionClass)) continue;
            Object value = this.classified.get(cls);
            this.classified.put(exceptionClass, value);
            return (C)value;
        }
        return this.defaultValue;
    }

    public final C getDefault() {
        return this.defaultValue;
    }

    protected Map<Class<? extends T>, C> getClassified() {
        return this.classified;
    }

    private static class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> arg0, Class<?> arg1) {
            if (arg0.isAssignableFrom(arg1)) {
                return 1;
            }
            return -1;
        }
    }
}

