/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.interceptor;

import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.MethodArgumentsKeyGenerator;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.retry.interceptor.NewMethodArgumentsIdentifier;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.DefaultRetryState;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class StatefulRetryOperationsInterceptor
implements MethodInterceptor {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    private MethodArgumentsKeyGenerator keyGenerator;
    private MethodInvocationRecoverer<?> recoverer;
    private NewMethodArgumentsIdentifier newMethodArgumentsIdentifier;
    private RetryOperations retryOperations;

    public StatefulRetryOperationsInterceptor() {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy(new NeverRetryPolicy());
        this.retryOperations = retryTemplate;
    }

    public void setRetryOperations(RetryOperations retryTemplate) {
        Assert.notNull((Object)retryTemplate, (String)"'retryOperations' cannot be null.");
        this.retryOperations = retryTemplate;
    }

    public void setRecoverer(MethodInvocationRecoverer<?> recoverer) {
        this.recoverer = recoverer;
    }

    public void setKeyGenerator(MethodArgumentsKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setNewItemIdentifier(NewMethodArgumentsIdentifier newMethodArgumentsIdentifier) {
        this.newMethodArgumentsIdentifier = newMethodArgumentsIdentifier;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] args;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing proxied method in stateful retry: " + invocation.getStaticPart() + "(" + ObjectUtils.getIdentityHexString((Object)invocation) + ")"));
        }
        Assert.state(((args = invocation.getArguments()).length > 0 ? 1 : 0) != 0, (String)("Stateful retry applied to method that takes no arguments: " + invocation.getStaticPart()));
        Object arg = args;
        if (args.length == 1) {
            arg = args[0];
        }
        Object[] item = arg;
        DefaultRetryState retryState = new DefaultRetryState(this.keyGenerator != null ? this.keyGenerator.getKey(args) : item, this.newMethodArgumentsIdentifier != null && this.newMethodArgumentsIdentifier.isNew(args));
        Object result = this.retryOperations.execute(new MethodInvocationRetryCallback(invocation), this.recoverer != null ? new ItemRecovererCallback(args, this.recoverer) : null, retryState);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting proxied method in stateful retry with result: (" + result + ")"));
        }
        return result;
    }

    private static final class ItemRecovererCallback
    implements RecoveryCallback<Object> {
        private final Object[] args;
        private final MethodInvocationRecoverer<?> recoverer;

        private ItemRecovererCallback(Object[] args, MethodInvocationRecoverer<?> recoverer) {
            this.args = Arrays.asList(args).toArray();
            this.recoverer = recoverer;
        }

        @Override
        public Object recover(RetryContext context) {
            return this.recoverer.recover(this.args, context.getLastThrowable());
        }
    }

    private static final class MethodInvocationRetryCallback
    implements RetryCallback<Object, Throwable> {
        private final MethodInvocation invocation;

        private MethodInvocationRetryCallback(MethodInvocation invocation) {
            this.invocation = invocation;
        }

        @Override
        public Object doWithRetry(RetryContext context) throws Exception {
            try {
                return this.invocation.proceed();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

