/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.util.WebUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasServiceTicketAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class CasAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private RequestMatcher proxyReceptorMatcher;
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage;
    private String artifactParameter = "ticket";
    private boolean authenticateAllArtifacts;
    private AuthenticationFailureHandler proxyFailureHandler = new SimpleUrlAuthenticationFailureHandler();
    private SecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    public CasAuthenticationFilter() {
        super("/login/cas");
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler());
        this.setSecurityContextRepository(this.securityContextRepository);
    }

    protected final void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        boolean continueFilterChain = this.proxyTicketRequest(this.serviceTicketRequest(request, response), request);
        if (!continueFilterChain) {
            super.successfulAuthentication(request, response, chain, authResult);
            return;
        }
        this.logger.debug((Object)LogMessage.format((String)"Authentication success. Updating SecurityContextHolder to contain: %s", (Object)authResult));
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authResult);
        SecurityContextHolder.setContext((SecurityContext)context);
        this.securityContextRepository.saveContext(context, request, response);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, ((Object)((Object)this)).getClass()));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        boolean serviceTicketRequest;
        if (this.proxyReceptorRequest(request)) {
            this.logger.debug((Object)"Responding to proxy receptor request");
            WebUtils.readAndRespondToProxyReceptorRequest((ServletRequest)request, (ServletResponse)response, (ProxyGrantingTicketStorage)this.proxyGrantingTicketStorage);
            return null;
        }
        String serviceTicket = this.obtainArtifact(request);
        if (serviceTicket == null) {
            this.logger.debug((Object)"Failed to obtain an artifact (cas ticket)");
            serviceTicket = "";
        }
        CasServiceTicketAuthenticationToken authRequest = (serviceTicketRequest = this.serviceTicketRequest(request, response)) ? CasServiceTicketAuthenticationToken.stateful(serviceTicket) : CasServiceTicketAuthenticationToken.stateless(serviceTicket);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected String obtainArtifact(HttpServletRequest request) {
        return request.getParameter(this.artifactParameter);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean result;
        boolean serviceTicketRequest = this.serviceTicketRequest(request, response);
        boolean bl = result = serviceTicketRequest || this.proxyReceptorRequest(request) || this.proxyTicketRequest(serviceTicketRequest, request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("requiresAuthentication = " + result));
        }
        return result;
    }

    public final void setProxyAuthenticationFailureHandler(AuthenticationFailureHandler proxyFailureHandler) {
        Assert.notNull((Object)proxyFailureHandler, (String)"proxyFailureHandler cannot be null");
        this.proxyFailureHandler = proxyFailureHandler;
    }

    public final void setAuthenticationFailureHandler(AuthenticationFailureHandler failureHandler) {
        super.setAuthenticationFailureHandler((AuthenticationFailureHandler)new CasAuthenticationFailureHandler(failureHandler));
    }

    public final void setProxyReceptorUrl(String proxyReceptorUrl) {
        this.proxyReceptorMatcher = new AntPathRequestMatcher("/**" + proxyReceptorUrl);
    }

    public final void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage proxyGrantingTicketStorage) {
        this.proxyGrantingTicketStorage = proxyGrantingTicketStorage;
    }

    public final void setServiceProperties(ServiceProperties serviceProperties) {
        this.artifactParameter = serviceProperties.getArtifactParameter();
        this.authenticateAllArtifacts = serviceProperties.isAuthenticateAllArtifacts();
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        super.setSecurityContextRepository(securityContextRepository);
        this.securityContextRepository = securityContextRepository;
    }

    private boolean serviceTicketRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean result = super.requiresAuthentication(request, response);
        this.logger.debug((Object)LogMessage.format((String)"serviceTicketRequest = %s", (Object)result));
        return result;
    }

    private boolean proxyTicketRequest(boolean serviceTicketRequest, HttpServletRequest request) {
        if (serviceTicketRequest) {
            return false;
        }
        boolean result = this.authenticateAllArtifacts && this.obtainArtifact(request) != null && !this.authenticated();
        this.logger.debug((Object)LogMessage.format((String)"proxyTicketRequest = %s", (Object)result));
        return result;
    }

    private boolean authenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.trustResolver.isAuthenticated(authentication);
    }

    private boolean proxyReceptorRequest(HttpServletRequest request) {
        boolean result = this.proxyReceptorConfigured() && this.proxyReceptorMatcher.matches(request);
        this.logger.debug((Object)LogMessage.format((String)"proxyReceptorRequest = %s", (Object)result));
        return result;
    }

    private boolean proxyReceptorConfigured() {
        boolean result = this.proxyGrantingTicketStorage != null && this.proxyReceptorMatcher != null;
        this.logger.debug((Object)LogMessage.format((String)"proxyReceptorConfigured = %s", (Object)result));
        return result;
    }

    private class CasAuthenticationFailureHandler
    implements AuthenticationFailureHandler {
        private final AuthenticationFailureHandler serviceTicketFailureHandler;

        CasAuthenticationFailureHandler(AuthenticationFailureHandler failureHandler) {
            Assert.notNull((Object)failureHandler, (String)"failureHandler");
            this.serviceTicketFailureHandler = failureHandler;
        }

        public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
            if (CasAuthenticationFilter.this.serviceTicketRequest(request, response)) {
                this.serviceTicketFailureHandler.onAuthenticationFailure(request, response, exception);
            } else {
                CasAuthenticationFilter.this.proxyFailureHandler.onAuthenticationFailure(request, response, exception);
            }
        }
    }
}

