/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;

public class DerbyMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    private static final String DEFAULT_DUMMY_NAME = "dummy";
    private String columnName;
    private String dummyName = "dummy";
    private int cacheSize = 1;
    private long[] valueCache = null;
    private int nextValueIndex = -1;

    public DerbyMaxValueIncrementer() {
    }

    public DerbyMaxValueIncrementer(DataSource ds, String incrementerName, String columnName) {
        this(ds, incrementerName, columnName, DEFAULT_DUMMY_NAME);
    }

    public DerbyMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, String dummyName) {
        this.setDataSource(ds);
        this.setIncrementerName(incrementerName);
        this.columnName = columnName;
        this.dummyName = dummyName;
        this.afterPropertiesSet();
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDummyName(String dummyName) {
        this.dummyName = dummyName;
    }

    public String getDummyName() {
        return this.dummyName;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.columnName == null) {
            throw new IllegalArgumentException("columnName is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextKey() throws DataAccessException {
        if (this.nextValueIndex < 0 || this.nextValueIndex >= this.getCacheSize()) {
            Connection con = DataSourceUtils.getConnection(this.getDataSource());
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                DataSourceUtils.applyTransactionTimeout(stmt, this.getDataSource());
                this.valueCache = new long[this.getCacheSize()];
                this.nextValueIndex = 0;
                for (int i = 0; i < this.getCacheSize(); ++i) {
                    stmt.executeUpdate("insert into " + this.getIncrementerName() + " (" + this.getDummyName() + ") values(null)");
                    ResultSet rs = stmt.executeQuery("select IDENTITY_VAL_LOCAL() from " + this.getIncrementerName());
                    try {
                        if (!rs.next()) {
                            throw new DataAccessResourceFailureException("IDENTITY_VAL_LOCAL() failed after executing an update");
                        }
                        this.valueCache[i] = rs.getLong(1);
                        continue;
                    }
                    finally {
                        JdbcUtils.closeResultSet(rs);
                    }
                }
                long maxValue = this.valueCache[this.valueCache.length - 1];
                stmt.executeUpdate("delete from " + this.getIncrementerName() + " where " + this.columnName + " < " + maxValue);
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not obtain IDENTITY value", (Throwable)ex);
            }
            finally {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.releaseConnection(con, this.getDataSource());
            }
        }
        return this.valueCache[this.nextValueIndex++];
    }
}

