/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class MappingJackson2MessageConverter
extends AbstractMessageConverter {
    private ObjectMapper objectMapper;
    private Boolean prettyPrint;

    public MappingJackson2MessageConverter() {
        super(new MimeType("application", "json", Charset.forName("UTF-8")));
        this.initObjectMapper();
    }

    public MappingJackson2MessageConverter(MimeType ... supportedMimeTypes) {
        super(Arrays.asList(supportedMimeTypes));
        this.initObjectMapper();
    }

    private void initObjectMapper() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    @Override
    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        if (targetClass == null) {
            return false;
        }
        JavaType javaType = this.objectMapper.constructType(targetClass);
        if (!this.logger.isWarnEnabled()) {
            return this.objectMapper.canDeserialize(javaType) && this.supportsMimeType(message.getHeaders());
        }
        AtomicReference causeRef = new AtomicReference();
        if (this.objectMapper.canDeserialize(javaType, causeRef) && this.supportsMimeType(message.getHeaders())) {
            return true;
        }
        Throwable cause = (Throwable)causeRef.get();
        if (cause != null) {
            String msg = "Failed to evaluate deserialization for type " + javaType;
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)msg, cause);
            } else {
                this.logger.warn((Object)(msg + ": " + cause));
            }
        }
        return false;
    }

    @Override
    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        if (!this.logger.isWarnEnabled()) {
            return this.objectMapper.canSerialize(payload.getClass()) && this.supportsMimeType(headers);
        }
        AtomicReference causeRef = new AtomicReference();
        if (this.objectMapper.canSerialize(payload.getClass(), causeRef) && this.supportsMimeType(headers)) {
            return true;
        }
        Throwable cause = (Throwable)causeRef.get();
        if (cause != null) {
            String msg = "Failed to evaluate serialization for type [" + payload.getClass() + "]";
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)msg, cause);
            } else {
                this.logger.warn((Object)(msg + ": " + cause));
            }
        }
        return false;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        JavaType javaType = this.objectMapper.constructType(targetClass);
        Object payload = message.getPayload();
        Class<?> view = this.getSerializationView(conversionHint);
        try {
            if (payload instanceof byte[]) {
                if (view != null) {
                    return this.objectMapper.readerWithView(view).forType(javaType).readValue((byte[])payload);
                }
                return this.objectMapper.readValue((byte[])payload, javaType);
            }
            if (view != null) {
                return this.objectMapper.readerWithView(view).forType(javaType).readValue(payload.toString());
            }
            return this.objectMapper.readValue(payload.toString(), javaType);
        }
        catch (IOException ex) {
            throw new MessageConversionException(message, "Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        try {
            Class<?> view = this.getSerializationView(conversionHint);
            if (byte[].class == this.getSerializedPayloadClass()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                JsonEncoding encoding = this.getJsonEncoding(this.getMimeType(headers));
                JsonGenerator generator = this.objectMapper.getFactory().createGenerator((OutputStream)out, encoding);
                if (view != null) {
                    this.objectMapper.writerWithView(view).writeValue(generator, payload);
                } else {
                    this.objectMapper.writeValue(generator, payload);
                }
                payload = out.toByteArray();
            } else {
                StringWriter writer = new StringWriter();
                if (view != null) {
                    this.objectMapper.writerWithView(view).writeValue((Writer)writer, payload);
                } else {
                    this.objectMapper.writeValue((Writer)writer, payload);
                }
                payload = ((Object)writer).toString();
            }
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
        return payload;
    }

    protected Class<?> getSerializationView(Object conversionHint) {
        if (conversionHint instanceof MethodParameter) {
            JsonView annotation;
            MethodParameter param = (MethodParameter)conversionHint;
            JsonView jsonView = annotation = param.getParameterIndex() >= 0 ? (JsonView)param.getParameterAnnotation(JsonView.class) : (JsonView)param.getMethodAnnotation(JsonView.class);
            if (annotation != null) {
                return this.extractViewClass(annotation, conversionHint);
            }
        } else {
            if (conversionHint instanceof JsonView) {
                return this.extractViewClass((JsonView)conversionHint, conversionHint);
            }
            if (conversionHint instanceof Class) {
                return (Class)conversionHint;
            }
        }
        return null;
    }

    private Class<?> extractViewClass(JsonView annotation, Object conversionHint) {
        Class[] classes = annotation.value();
        if (classes.length != 1) {
            throw new IllegalArgumentException("@JsonView only supported for handler methods with exactly 1 class argument: " + conversionHint);
        }
        return classes[0];
    }

    protected JsonEncoding getJsonEncoding(MimeType contentType) {
        if (contentType != null && contentType.getCharSet() != null) {
            Charset charset = contentType.getCharSet();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }
}

