/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.user.SimpSession;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class DefaultUserDestinationResolver
implements UserDestinationResolver {
    private static final Log logger = LogFactory.getLog(DefaultUserDestinationResolver.class);
    private final SimpUserRegistry userRegistry;
    private String prefix = "/user/";
    private boolean keepLeadingSlash = true;

    public DefaultUserDestinationResolver(SimpUserRegistry userRegistry) {
        Assert.notNull((Object)userRegistry, (String)"'userRegistry' must not be null");
        this.userRegistry = userRegistry;
    }

    public SimpUserRegistry getSimpUserRegistry() {
        return this.userRegistry;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"prefix must not be empty");
        this.prefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public String getDestinationPrefix() {
        return this.prefix;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        if (pathMatcher != null) {
            this.keepLeadingSlash = pathMatcher.combine("1", "2").equals("1/2");
        }
    }

    @Override
    public UserDestinationResult resolveDestination(Message<?> message) {
        String sourceDestination = SimpMessageHeaderAccessor.getDestination(message.getHeaders());
        ParseResult parseResult = this.parse(message);
        if (parseResult == null) {
            return null;
        }
        String user = parseResult.getUser();
        HashSet<String> targetSet = new HashSet<String>();
        for (String sessionId : parseResult.getSessionIds()) {
            String actualDestination = parseResult.getActualDestination();
            String targetDestination = this.getTargetDestination(sourceDestination, actualDestination, sessionId, user);
            if (targetDestination == null) continue;
            targetSet.add(targetDestination);
        }
        String subscribeDestination = parseResult.getSubscribeDestination();
        return new UserDestinationResult(sourceDestination, targetSet, subscribeDestination, user);
    }

    private ParseResult parse(Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        String destination = SimpMessageHeaderAccessor.getDestination(headers);
        if (destination == null || !this.checkDestination(destination, this.prefix)) {
            return null;
        }
        SimpMessageType messageType = SimpMessageHeaderAccessor.getMessageType(headers);
        Principal principal = SimpMessageHeaderAccessor.getUser(headers);
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        if (SimpMessageType.SUBSCRIBE.equals((Object)messageType) || SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            if (sessionId == null) {
                logger.error((Object)("No session id. Ignoring " + message));
                return null;
            }
            int prefixEnd = this.prefix.length() - 1;
            String actualDestination = destination.substring(prefixEnd);
            if (!this.keepLeadingSlash) {
                actualDestination = actualDestination.substring(1);
            }
            String user = principal != null ? principal.getName() : null;
            return new ParseResult(actualDestination, destination, Collections.singleton(sessionId), user);
        }
        if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            Set<String> sessionIds;
            int prefixEnd = this.prefix.length();
            int userEnd = destination.indexOf(47, prefixEnd);
            Assert.isTrue((userEnd > 0 ? 1 : 0) != 0, (String)"Expected destination pattern \"/user/{userId}/**\"");
            String actualDestination = destination.substring(userEnd);
            String subscribeDestination = this.prefix.substring(0, prefixEnd - 1) + actualDestination;
            String userName = destination.substring(prefixEnd, userEnd);
            userName = StringUtils.replace((String)userName, (String)"%2F", (String)"/");
            if (userName.equals(sessionId)) {
                userName = null;
                sessionIds = Collections.singleton(sessionId);
            } else {
                SimpUser user = this.userRegistry.getUser(userName);
                if (user != null) {
                    if (user.getSession(sessionId) != null) {
                        sessionIds = Collections.singleton(sessionId);
                    } else {
                        Set<SimpSession> sessions = user.getSessions();
                        sessionIds = new HashSet<String>(sessions.size());
                        for (SimpSession session : sessions) {
                            sessionIds.add(session.getId());
                        }
                    }
                } else {
                    sessionIds = Collections.emptySet();
                }
            }
            if (!this.keepLeadingSlash) {
                actualDestination = actualDestination.substring(1);
            }
            return new ParseResult(actualDestination, subscribeDestination, sessionIds, userName);
        }
        return null;
    }

    protected boolean checkDestination(String destination, String requiredPrefix) {
        return destination.startsWith(requiredPrefix);
    }

    protected String getTargetDestination(String sourceDestination, String actualDestination, String sessionId, String user) {
        return actualDestination + "-user" + sessionId;
    }

    public String toString() {
        return "DefaultUserDestinationResolver[prefix=" + this.prefix + "]";
    }

    private static class ParseResult {
        private final String actualDestination;
        private final String subscribeDestination;
        private final Set<String> sessionIds;
        private final String user;

        public ParseResult(String actualDest, String subscribeDest, Set<String> sessionIds, String user) {
            this.actualDestination = actualDest;
            this.subscribeDestination = subscribeDest;
            this.sessionIds = sessionIds;
            this.user = user;
        }

        public String getActualDestination() {
            return this.actualDestination;
        }

        public String getSubscribeDestination() {
            return this.subscribeDestination;
        }

        public Set<String> getSessionIds() {
            return this.sessionIds;
        }

        public String getUser() {
            return this.user;
        }
    }
}

