/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.metadata.CompositeMetadataFlyweight;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.PayloadUtils;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class DefaultRSocketRequester
implements RSocketRequester {
    static final MimeType COMPOSITE_METADATA = new MimeType("message", "x.rsocket.composite-metadata.v0");
    static final MimeType ROUTING = new MimeType("message", "x.rsocket.routing.v0");
    static final List<MimeType> METADATA_MIME_TYPES = Arrays.asList(COMPOSITE_METADATA, ROUTING);
    private static final Map<String, Object> EMPTY_HINTS = Collections.emptyMap();
    private final RSocket rsocket;
    private final MimeType dataMimeType;
    private final MimeType metadataMimeType;
    private final RSocketStrategies strategies;
    private final DataBuffer emptyDataBuffer;

    DefaultRSocketRequester(RSocket rsocket, MimeType dataMimeType, MimeType metadataMimeType, RSocketStrategies strategies) {
        Assert.notNull((Object)rsocket, (String)"RSocket is required");
        Assert.notNull((Object)dataMimeType, (String)"'dataMimeType' is required");
        Assert.notNull((Object)metadataMimeType, (String)"'metadataMimeType' is required");
        Assert.notNull((Object)strategies, (String)"RSocketStrategies is required");
        Assert.isTrue((boolean)METADATA_MIME_TYPES.contains(metadataMimeType), () -> "Unexpected metadatata mime type: '" + metadataMimeType + "'");
        this.rsocket = rsocket;
        this.dataMimeType = dataMimeType;
        this.metadataMimeType = metadataMimeType;
        this.strategies = strategies;
        this.emptyDataBuffer = this.strategies.dataBufferFactory().wrap(new byte[0]);
    }

    @Override
    public RSocket rsocket() {
        return this.rsocket;
    }

    @Override
    public MimeType dataMimeType() {
        return this.dataMimeType;
    }

    @Override
    public MimeType metadataMimeType() {
        return this.metadataMimeType;
    }

    @Override
    public RSocketRequester.RequestSpec route(String route) {
        return new DefaultRequestSpec(route);
    }

    private static boolean isVoid(ResolvableType elementType) {
        return Void.class.equals((Object)elementType.resolve()) || Void.TYPE.equals(elementType.resolve());
    }

    private DataBufferFactory bufferFactory() {
        return this.strategies.dataBufferFactory();
    }

    private class DefaultResponseSpec
    implements RSocketRequester.ResponseSpec {
        @Nullable
        private final Mono<Payload> payloadMono;
        @Nullable
        private final Flux<Payload> payloadFlux;

        DefaultResponseSpec(Mono<Payload> payloadMono) {
            this.payloadMono = payloadMono;
            this.payloadFlux = null;
        }

        DefaultResponseSpec(Flux<Payload> payloadFlux) {
            this.payloadMono = null;
            this.payloadFlux = payloadFlux;
        }

        @Override
        public Mono<Void> send() {
            Assert.state((this.payloadMono != null ? 1 : 0) != 0, (String)"No RSocket interaction model for one-way send with Flux");
            return this.payloadMono.flatMap(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).fireAndForget(arg_0));
        }

        @Override
        public <T> Mono<T> retrieveMono(Class<T> dataType) {
            return this.retrieveMono(ResolvableType.forClass(dataType));
        }

        @Override
        public <T> Mono<T> retrieveMono(ParameterizedTypeReference<T> dataTypeRef) {
            return this.retrieveMono(ResolvableType.forType(dataTypeRef));
        }

        @Override
        public <T> Flux<T> retrieveFlux(Class<T> dataType) {
            return this.retrieveFlux(ResolvableType.forClass(dataType));
        }

        @Override
        public <T> Flux<T> retrieveFlux(ParameterizedTypeReference<T> dataTypeRef) {
            return this.retrieveFlux(ResolvableType.forType(dataTypeRef));
        }

        private <T> Mono<T> retrieveMono(ResolvableType elementType) {
            Assert.notNull(this.payloadMono, (String)"No RSocket interaction model for Flux request to Mono response.");
            Mono payloadMono = this.payloadMono.flatMap(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).requestResponse(arg_0));
            if (DefaultRSocketRequester.isVoid(elementType)) {
                return payloadMono.then();
            }
            Decoder decoder = DefaultRSocketRequester.this.strategies.decoder(elementType, DefaultRSocketRequester.this.dataMimeType);
            return payloadMono.map(this::retainDataAndReleasePayload).map(dataBuffer -> decoder.decode(dataBuffer, elementType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS));
        }

        private <T> Flux<T> retrieveFlux(ResolvableType elementType) {
            Flux payloadFlux;
            Flux flux = this.payloadMono != null ? this.payloadMono.flatMapMany(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).requestStream(arg_0)) : (payloadFlux = DefaultRSocketRequester.this.rsocket.requestChannel(this.payloadFlux));
            if (DefaultRSocketRequester.isVoid(elementType)) {
                return payloadFlux.thenMany((Publisher)Flux.empty());
            }
            Decoder decoder = DefaultRSocketRequester.this.strategies.decoder(elementType, DefaultRSocketRequester.this.dataMimeType);
            return payloadFlux.map(this::retainDataAndReleasePayload).map(dataBuffer -> decoder.decode(dataBuffer, elementType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS));
        }

        private DataBuffer retainDataAndReleasePayload(Payload payload) {
            return PayloadUtils.retainDataAndReleasePayload(payload, DefaultRSocketRequester.this.bufferFactory());
        }
    }

    private class DefaultRequestSpec
    implements RSocketRequester.RequestSpec {
        private final Map<Object, MimeType> metadata = new LinkedHashMap<Object, MimeType>(4);

        public DefaultRequestSpec(String route) {
            Assert.notNull((Object)route, (String)"'route' is required");
            this.metadata(route, ROUTING);
        }

        @Override
        public RSocketRequester.RequestSpec metadata(Object metadata, MimeType mimeType) {
            Assert.isTrue((this.metadata.isEmpty() || DefaultRSocketRequester.this.metadataMimeType().equals((Object)COMPOSITE_METADATA) ? 1 : 0) != 0, (String)"Additional metadata entries supported only with composite metadata");
            this.metadata.put(metadata, mimeType);
            return this;
        }

        @Override
        public RSocketRequester.ResponseSpec data(Object data) {
            Assert.notNull((Object)data, (String)"'data' must not be null");
            return this.toResponseSpec(data, ResolvableType.NONE);
        }

        @Override
        public <T, P extends Publisher<T>> RSocketRequester.ResponseSpec data(P publisher, Class<T> dataType) {
            Assert.notNull(publisher, (String)"'publisher' must not be null");
            Assert.notNull(dataType, (String)"'dataType' must not be null");
            return this.toResponseSpec(publisher, ResolvableType.forClass(dataType));
        }

        @Override
        public <T, P extends Publisher<T>> RSocketRequester.ResponseSpec data(P publisher, ParameterizedTypeReference<T> dataTypeRef) {
            Assert.notNull(publisher, (String)"'publisher' must not be null");
            Assert.notNull(dataTypeRef, (String)"'dataTypeRef' must not be null");
            return this.toResponseSpec(publisher, ResolvableType.forType(dataTypeRef));
        }

        private RSocketRequester.ResponseSpec toResponseSpec(Object input, ResolvableType dataType) {
            Encoder encoder;
            Publisher publisher;
            ReactiveAdapter adapter = DefaultRSocketRequester.this.strategies.reactiveAdapterRegistry().getAdapter(input.getClass());
            if (input instanceof Publisher) {
                publisher = (Publisher)input;
            } else if (adapter != null) {
                publisher = adapter.toPublisher(input);
            } else {
                Mono payloadMono = Mono.fromCallable(() -> this.encodeData(input, ResolvableType.forInstance((Object)input), null)).map(this::firstPayload).doOnDiscard(Payload.class, ReferenceCounted::release).switchIfEmpty(this.emptyPayload());
                return new DefaultResponseSpec((Mono<Payload>)payloadMono);
            }
            if (DefaultRSocketRequester.isVoid(dataType) || adapter != null && adapter.isNoValue()) {
                Mono payloadMono = Mono.when((Publisher[])new Publisher[]{publisher}).then(this.emptyPayload());
                return new DefaultResponseSpec((Mono<Payload>)payloadMono);
            }
            Encoder encoder2 = encoder = dataType != ResolvableType.NONE && !Object.class.equals((Object)dataType.resolve()) ? DefaultRSocketRequester.this.strategies.encoder(dataType, DefaultRSocketRequester.this.dataMimeType) : null;
            if (adapter != null && !adapter.isMultiValue()) {
                Mono payloadMono = Mono.from((Publisher)publisher).map(value -> this.encodeData(value, dataType, encoder)).map(this::firstPayload).switchIfEmpty(this.emptyPayload());
                return new DefaultResponseSpec((Mono<Payload>)payloadMono);
            }
            Flux payloadFlux = Flux.from((Publisher)publisher).map(value -> this.encodeData(value, dataType, encoder)).switchOnFirst((signal, inner) -> {
                DataBuffer data = (DataBuffer)signal.get();
                if (data != null) {
                    return Mono.fromCallable(() -> this.firstPayload(data)).concatWith((Publisher)inner.skip(1L).map(PayloadUtils::createPayload));
                }
                return inner.map(PayloadUtils::createPayload);
            }).doOnDiscard(Payload.class, ReferenceCounted::release).switchIfEmpty(this.emptyPayload());
            return new DefaultResponseSpec((Flux<Payload>)payloadFlux);
        }

        private <T> DataBuffer encodeData(T value, ResolvableType valueType, @Nullable Encoder<?> encoder) {
            if (value instanceof DataBuffer) {
                return (DataBuffer)value;
            }
            if (encoder == null) {
                valueType = ResolvableType.forInstance(value);
                encoder = DefaultRSocketRequester.this.strategies.encoder(valueType, DefaultRSocketRequester.this.dataMimeType);
            }
            return encoder.encodeValue(value, DefaultRSocketRequester.this.bufferFactory(), valueType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS);
        }

        private Payload firstPayload(DataBuffer data) {
            try {
                DataBuffer metadata = this.getMetadata();
                return PayloadUtils.createPayload(metadata, data);
            }
            catch (Throwable ex) {
                DataBufferUtils.release((DataBuffer)data);
                throw ex;
            }
        }

        private Mono<Payload> emptyPayload() {
            return Mono.fromCallable(() -> this.firstPayload(DefaultRSocketRequester.this.emptyDataBuffer));
        }

        private DataBuffer getMetadata() {
            if (DefaultRSocketRequester.this.metadataMimeType().equals((Object)COMPOSITE_METADATA)) {
                CompositeByteBuf metadata = this.getAllocator().compositeBuffer();
                this.metadata.forEach((key, value) -> {
                    DataBuffer dataBuffer = this.encodeMetadata(key, (MimeType)value);
                    CompositeMetadataFlyweight.encodeAndAddMetadata((CompositeByteBuf)metadata, (ByteBufAllocator)this.getAllocator(), (String)value.toString(), (ByteBuf)(dataBuffer instanceof NettyDataBuffer ? ((NettyDataBuffer)dataBuffer).getNativeBuffer() : Unpooled.wrappedBuffer((ByteBuffer)dataBuffer.asByteBuffer())));
                });
                return this.asDataBuffer((ByteBuf)metadata);
            }
            Assert.isTrue((this.metadata.size() < 2 ? 1 : 0) != 0, (String)"Composite metadata required for multiple entries");
            Map.Entry<Object, MimeType> entry = this.metadata.entrySet().iterator().next();
            Assert.isTrue((boolean)DefaultRSocketRequester.this.metadataMimeType().equals((Object)entry.getValue()), () -> "Expected metadata MimeType '" + DefaultRSocketRequester.this.metadataMimeType() + "', actual " + this.metadata);
            return this.encodeMetadata(entry.getKey(), entry.getValue());
        }

        private <T> DataBuffer encodeMetadata(Object metadata, MimeType mimeType) {
            if (metadata instanceof DataBuffer) {
                return (DataBuffer)metadata;
            }
            ResolvableType type = ResolvableType.forInstance((Object)metadata);
            Encoder encoder = DefaultRSocketRequester.this.strategies.encoder(type, mimeType);
            Assert.notNull(encoder, () -> "No encoder for metadata " + metadata + ", mimeType '" + mimeType + "'");
            return encoder.encodeValue(metadata, DefaultRSocketRequester.this.bufferFactory(), type, mimeType, EMPTY_HINTS);
        }

        private ByteBufAllocator getAllocator() {
            return DefaultRSocketRequester.this.bufferFactory() instanceof NettyDataBufferFactory ? ((NettyDataBufferFactory)DefaultRSocketRequester.this.bufferFactory()).getByteBufAllocator() : ByteBufAllocator.DEFAULT;
        }

        private DataBuffer asDataBuffer(ByteBuf byteBuf) {
            if (DefaultRSocketRequester.this.bufferFactory() instanceof NettyDataBufferFactory) {
                return ((NettyDataBufferFactory)DefaultRSocketRequester.this.bufferFactory()).wrap(byteBuf);
            }
            DataBuffer dataBuffer = DefaultRSocketRequester.this.bufferFactory().wrap(byteBuf.nioBuffer());
            byteBuf.release();
            return dataBuffer;
        }
    }
}

