/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.rsocket.Payload;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.reactive.AbstractEncoderMethodReturnValueHandler;
import org.springframework.messaging.rsocket.PayloadUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class RSocketPayloadReturnValueHandler
extends AbstractEncoderMethodReturnValueHandler {
    public static final String RESPONSE_HEADER = "rsocketResponse";

    public RSocketPayloadReturnValueHandler(List<Encoder<?>> encoders, ReactiveAdapterRegistry registry) {
        super(encoders, registry);
    }

    @Override
    protected Mono<Void> handleEncodedContent(Flux<DataBuffer> encodedContent, MethodParameter returnType, Message<?> message) {
        MonoProcessor<Flux<Payload>> replyMono = this.getReplyMono(message);
        Assert.notNull(replyMono, (String)"Missing 'rsocketResponse'");
        replyMono.onNext((Object)encodedContent.map(PayloadUtils::createPayload));
        replyMono.onComplete();
        return Mono.empty();
    }

    @Override
    protected Mono<Void> handleNoContent(MethodParameter returnType, Message<?> message) {
        MonoProcessor<Flux<Payload>> replyMono = this.getReplyMono(message);
        if (replyMono != null) {
            replyMono.onComplete();
        }
        return Mono.empty();
    }

    @Nullable
    private MonoProcessor<Flux<Payload>> getReplyMono(Message<?> message) {
        Object headerValue = message.getHeaders().get(RESPONSE_HEADER);
        Assert.state((headerValue == null || headerValue instanceof MonoProcessor ? 1 : 0) != 0, (String)"Expected MonoProcessor");
        return (MonoProcessor)headerValue;
    }
}

