/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.springframework.test.web.reactive.server.DefaultWebTestClientBuilder;
import org.springframework.test.web.reactive.server.ExchangeMutatingWebFilter;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

abstract class AbstractMockServerSpec<B extends WebTestClient.MockServerSpec<B>>
implements WebTestClient.MockServerSpec<B> {
    private final ExchangeMutatingWebFilter exchangeMutatingWebFilter = new ExchangeMutatingWebFilter();
    private final List<WebFilter> filters = new ArrayList<WebFilter>(4);

    AbstractMockServerSpec() {
        this.filters.add(this.exchangeMutatingWebFilter);
    }

    @Override
    public <T extends B> T exchangeMutator(UnaryOperator<ServerWebExchange> mutator) {
        this.exchangeMutatingWebFilter.registerGlobalMutator(mutator);
        return this.self();
    }

    @Override
    public <T extends B> T webFilter(WebFilter ... filter) {
        this.filters.addAll(Arrays.asList(filter));
        return this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    @Override
    public WebTestClient.Builder configureClient() {
        WebHttpHandlerBuilder builder = this.initHttpHandlerBuilder();
        this.filtersInReverse().forEach(arg_0 -> ((WebHttpHandlerBuilder)builder).prependFilter(arg_0));
        return new DefaultWebTestClientBuilder(builder.build(), this.exchangeMutatingWebFilter);
    }

    protected abstract WebHttpHandlerBuilder initHttpHandlerBuilder();

    private List<WebFilter> filtersInReverse() {
        ArrayList<WebFilter> result = new ArrayList<WebFilter>(this.filters);
        Collections.reverse(result);
        return result;
    }

    @Override
    public WebTestClient build() {
        return this.configureClient().build();
    }
}

