/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.ExchangeMutatingWebFilter;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.HeaderAssertions;
import org.springframework.test.web.reactive.server.JsonPathAssertions;
import org.springframework.test.web.reactive.server.StatusAssertions;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WiretapConnector;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultWebTestClient
implements WebTestClient {
    private final WebClient webClient;
    private final WiretapConnector wiretapConnector;
    private final ExchangeMutatingWebFilter exchangeMutatingWebFilter;
    private final Duration timeout;
    private final AtomicLong requestIndex = new AtomicLong();

    DefaultWebTestClient(WebClient.Builder webClientBuilder, ClientHttpConnector connector, ExchangeMutatingWebFilter filter, Duration timeout) {
        Assert.notNull((Object)webClientBuilder, (String)"WebClient.Builder is required");
        this.wiretapConnector = new WiretapConnector(connector);
        this.webClient = webClientBuilder.clientConnector((ClientHttpConnector)this.wiretapConnector).build();
        this.exchangeMutatingWebFilter = filter != null ? filter : new ExchangeMutatingWebFilter();
        this.timeout = timeout != null ? timeout : Duration.ofSeconds(5L);
    }

    private DefaultWebTestClient(DefaultWebTestClient webTestClient, ExchangeFilterFunction filter) {
        this.webClient = webTestClient.webClient.filter(filter);
        this.wiretapConnector = webTestClient.wiretapConnector;
        this.exchangeMutatingWebFilter = webTestClient.exchangeMutatingWebFilter;
        this.timeout = webTestClient.timeout;
    }

    private Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public WebTestClient.UriSpec<WebTestClient.RequestHeadersSpec<?>> get() {
        return this.toUriSpec(wc -> wc.method(HttpMethod.GET));
    }

    @Override
    public WebTestClient.UriSpec<WebTestClient.RequestHeadersSpec<?>> head() {
        return this.toUriSpec(wc -> wc.method(HttpMethod.HEAD));
    }

    @Override
    public WebTestClient.UriSpec<WebTestClient.RequestBodySpec> post() {
        return this.toUriSpec(wc -> wc.method(HttpMethod.POST));
    }

    @Override
    public WebTestClient.UriSpec<WebTestClient.RequestBodySpec> put() {
        return this.toUriSpec(wc -> wc.method(HttpMethod.PUT));
    }

    @Override
    public WebTestClient.UriSpec<WebTestClient.RequestBodySpec> patch() {
        return this.toUriSpec(wc -> wc.method(HttpMethod.PATCH));
    }

    @Override
    public WebTestClient.UriSpec<WebTestClient.RequestHeadersSpec<?>> delete() {
        return this.toUriSpec(wc -> wc.method(HttpMethod.DELETE));
    }

    @Override
    public WebTestClient.UriSpec<WebTestClient.RequestHeadersSpec<?>> options() {
        return this.toUriSpec(wc -> wc.method(HttpMethod.OPTIONS));
    }

    private <S extends WebTestClient.RequestHeadersSpec<?>> WebTestClient.UriSpec<S> toUriSpec(Function<WebClient, WebClient.UriSpec<WebClient.RequestBodySpec>> function) {
        return new DefaultUriSpec(function.apply(this.webClient));
    }

    @Override
    public WebTestClient filter(ExchangeFilterFunction filter) {
        return new DefaultWebTestClient(this, filter);
    }

    @Override
    public WebTestClient exchangeMutator(UnaryOperator<ServerWebExchange> mutator) {
        Assert.notNull((Object)this.exchangeMutatingWebFilter, (String)"This option is applicable only for tests without an actual running server");
        return this.filter((request, next) -> {
            String requestId = request.headers().getFirst("request-id");
            Assert.notNull((Object)requestId, (String)"No request-id header");
            this.exchangeMutatingWebFilter.registerPerRequestMutator(requestId, mutator);
            return next.exchange(request);
        });
    }

    private static class DefaultBodyContentSpec
    implements WebTestClient.BodyContentSpec {
        private final EntityExchangeResult<byte[]> result;
        private final boolean isEmpty;

        DefaultBodyContentSpec(EntityExchangeResult<byte[]> result) {
            this.result = result;
            this.isEmpty = result.getResponseBody() == null;
        }

        @Override
        public EntityExchangeResult<Void> isEmpty() {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue("Expected empty body", this.isEmpty));
            return new EntityExchangeResult<Object>(this.result, null);
        }

        @Override
        public WebTestClient.BodyContentSpec json(String json) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    new JsonExpectationsHelper().assertJsonEqual(json, this.getBodyAsString());
                }
                catch (Exception ex) {
                    throw new AssertionError("JSON parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public JsonPathAssertions jsonPath(String expression, Object ... args) {
            return new JsonPathAssertions(this, expression, args);
        }

        @Override
        public WebTestClient.BodyContentSpec consumeAsStringWith(Consumer<String> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.getBodyAsString()));
            return this;
        }

        private String getBodyAsString() {
            if (this.isEmpty) {
                return null;
            }
            MediaType mediaType = this.result.getResponseHeaders().getContentType();
            Charset charset = Optional.ofNullable(mediaType).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
            return new String(this.result.getResponseBody(), charset);
        }

        @Override
        public WebTestClient.BodyContentSpec consumeWith(Consumer<byte[]> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result.getResponseBody()));
            return this;
        }

        @Override
        public EntityExchangeResult<byte[]> returnResult() {
            return this.result;
        }
    }

    private static class DefaultListBodySpec<E>
    extends DefaultBodySpec<List<E>, WebTestClient.ListBodySpec<E>>
    implements WebTestClient.ListBodySpec<E> {
        DefaultListBodySpec(EntityExchangeResult<List<E>> result) {
            super(result);
        }

        @Override
        public WebTestClient.ListBodySpec<E> hasSize(int size) {
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body does not contain " + size + " elements";
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, size, actual.size()));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec<E> contains(E ... elements) {
            List expected = Arrays.asList(elements);
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body does not contain " + expected;
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual.containsAll(expected)));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec<E> doesNotContain(E ... elements) {
            List expected = Arrays.asList(elements);
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body should have contained " + expected;
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, !actual.containsAll(expected)));
            return this;
        }

        @Override
        public EntityExchangeResult<List<E>> returnResult() {
            return this.getResult();
        }
    }

    private static class DefaultBodySpec<B, S extends WebTestClient.BodySpec<B, S>>
    implements WebTestClient.BodySpec<B, S> {
        private final EntityExchangeResult<B> result;

        DefaultBodySpec(EntityExchangeResult<B> result) {
            this.result = result;
        }

        protected EntityExchangeResult<B> getResult() {
            return this.result;
        }

        @Override
        public <T extends S> T isEqualTo(B expected) {
            Object actual = this.result.getResponseBody();
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response body", expected, actual));
            return this.self();
        }

        @Override
        public <T extends S> T consumeWith(Consumer<B> consumer) {
            Object actual = this.result.getResponseBody();
            this.result.assertWithDiagnostics(() -> consumer.accept(actual));
            return this.self();
        }

        private <T extends S> T self() {
            return (T)this;
        }

        @Override
        public EntityExchangeResult<B> returnResult() {
            return this.result;
        }
    }

    private static class DefaultResponseSpec
    implements WebTestClient.ResponseSpec {
        private final UndecodedExchangeResult result;

        DefaultResponseSpec(ExchangeResult result, ClientResponse response, Duration timeout) {
            this.result = new UndecodedExchangeResult(result, response, timeout);
        }

        @Override
        public StatusAssertions expectStatus() {
            return new StatusAssertions(this.result, this);
        }

        @Override
        public HeaderAssertions expectHeader() {
            return new HeaderAssertions(this.result, this);
        }

        @Override
        public <B> WebTestClient.BodySpec<B, ?> expectBody(Class<B> bodyType) {
            return this.expectBody(ResolvableType.forClass(bodyType));
        }

        @Override
        public <B> WebTestClient.BodySpec<B, ?> expectBody(ResolvableType bodyType) {
            return new DefaultBodySpec(this.result.decode(bodyType));
        }

        @Override
        public <E> WebTestClient.ListBodySpec<E> expectBodyList(Class<E> elementType) {
            return this.expectBodyList(ResolvableType.forClass(elementType));
        }

        @Override
        public <E> WebTestClient.ListBodySpec<E> expectBodyList(ResolvableType elementType) {
            return new DefaultListBodySpec(this.result.decodeToList(elementType));
        }

        @Override
        public WebTestClient.BodyContentSpec expectBody() {
            return new DefaultBodyContentSpec(this.result.decodeToByteArray());
        }

        @Override
        public <T> FluxExchangeResult<T> returnResult(Class<T> elementType) {
            return this.returnResult(ResolvableType.forClass(elementType));
        }

        @Override
        public <T> FluxExchangeResult<T> returnResult(ResolvableType elementType) {
            return this.result.decodeToFlux(elementType);
        }
    }

    private static class UndecodedExchangeResult
    extends ExchangeResult {
        private final ClientResponse response;
        private final Duration timeout;

        UndecodedExchangeResult(ExchangeResult result, ClientResponse response, Duration timeout) {
            super(result);
            this.response = response;
            this.timeout = timeout;
        }

        public <T> EntityExchangeResult<T> decode(ResolvableType bodyType) {
            Object body = ((Mono)this.response.body(BodyExtractors.toMono((ResolvableType)bodyType))).block(this.timeout);
            return new EntityExchangeResult<Object>(this, body);
        }

        public <T> EntityExchangeResult<List<T>> decodeToList(ResolvableType elementType) {
            Flux flux = (Flux)this.response.body(BodyExtractors.toFlux((ResolvableType)elementType));
            List body = (List)flux.collectList().block(this.timeout);
            return new EntityExchangeResult<List<T>>(this, body);
        }

        public <T> FluxExchangeResult<T> decodeToFlux(ResolvableType elementType) {
            Flux body = (Flux)this.response.body(BodyExtractors.toFlux((ResolvableType)elementType));
            return new FluxExchangeResult(this, body, this.timeout);
        }

        public EntityExchangeResult<byte[]> decodeToByteArray() {
            ByteArrayResource resource = (ByteArrayResource)((Mono)this.response.body(BodyExtractors.toMono(ByteArrayResource.class))).block(this.timeout);
            byte[] body = resource != null ? resource.getByteArray() : null;
            return new EntityExchangeResult<byte[]>(this, body);
        }
    }

    private class DefaultRequestBodySpec
    implements WebTestClient.RequestBodySpec {
        private final WebClient.RequestBodySpec bodySpec;
        private final String requestId;

        DefaultRequestBodySpec(WebClient.RequestBodySpec spec) {
            this.bodySpec = spec;
            this.requestId = String.valueOf(DefaultWebTestClient.this.requestIndex.incrementAndGet());
            this.bodySpec.header("request-id", new String[]{this.requestId});
        }

        @Override
        public WebTestClient.RequestBodySpec header(String headerName, String ... headerValues) {
            this.bodySpec.header(headerName, headerValues);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec headers(HttpHeaders headers) {
            this.bodySpec.headers(headers);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec accept(MediaType ... acceptableMediaTypes) {
            this.bodySpec.accept(acceptableMediaTypes);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec acceptCharset(Charset ... acceptableCharsets) {
            this.bodySpec.acceptCharset(acceptableCharsets);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec contentType(MediaType contentType) {
            this.bodySpec.contentType(contentType);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec contentLength(long contentLength) {
            this.bodySpec.contentLength(contentLength);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec cookie(String name, String value) {
            this.bodySpec.cookie(name, value);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec cookies(MultiValueMap<String, String> cookies) {
            this.bodySpec.cookies(cookies);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.bodySpec.ifModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec ifNoneMatch(String ... ifNoneMatches) {
            this.bodySpec.ifNoneMatch(ifNoneMatches);
            return this;
        }

        @Override
        public WebTestClient.ResponseSpec exchange() {
            return this.toResponseSpec((Mono<ClientResponse>)this.bodySpec.exchange());
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.bodySpec.body(inserter);
            return this;
        }

        @Override
        public <T, S extends Publisher<T>> WebTestClient.RequestHeadersSpec<?> body(S publisher, Class<T> elementClass) {
            this.bodySpec.body(publisher, elementClass);
            return this;
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> syncBody(Object body) {
            this.bodySpec.syncBody(body);
            return this;
        }

        private DefaultResponseSpec toResponseSpec(Mono<ClientResponse> mono) {
            ClientResponse clientResponse = (ClientResponse)mono.block(DefaultWebTestClient.this.getTimeout());
            ExchangeResult exchangeResult = DefaultWebTestClient.this.wiretapConnector.claimRequest(this.requestId);
            return new DefaultResponseSpec(exchangeResult, clientResponse, DefaultWebTestClient.this.getTimeout());
        }
    }

    private class DefaultUriSpec<S extends WebTestClient.RequestHeadersSpec<?>>
    implements WebTestClient.UriSpec<S> {
        private final WebClient.UriSpec<WebClient.RequestBodySpec> uriSpec;

        DefaultUriSpec(WebClient.UriSpec<WebClient.RequestBodySpec> spec) {
            this.uriSpec = spec;
        }

        @Override
        public S uri(URI uri) {
            return (S)new DefaultRequestBodySpec((WebClient.RequestBodySpec)this.uriSpec.uri(uri));
        }

        @Override
        public S uri(String uriTemplate, Object ... uriVariables) {
            return (S)new DefaultRequestBodySpec((WebClient.RequestBodySpec)this.uriSpec.uri(uriTemplate, uriVariables));
        }

        @Override
        public S uri(String uriTemplate, Map<String, ?> uriVariables) {
            return (S)new DefaultRequestBodySpec((WebClient.RequestBodySpec)this.uriSpec.uri(uriTemplate, uriVariables));
        }

        @Override
        public S uri(Function<UriBuilder, URI> uriBuilder) {
            return (S)new DefaultRequestBodySpec((WebClient.RequestBodySpec)this.uriSpec.uri(uriBuilder));
        }
    }
}

