/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.springframework.test.web.reactive.server.WiretapConnector;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

class ExchangeMutatingWebFilter
implements WebFilter {
    private static final Function<ServerWebExchange, ServerWebExchange> NO_OP_MUTATOR = e -> e;
    private volatile Function<ServerWebExchange, ServerWebExchange> globalMutator = NO_OP_MUTATOR;
    private final Map<String, Function<ServerWebExchange, ServerWebExchange>> perRequestMutators = new ConcurrentHashMap<String, Function<ServerWebExchange, ServerWebExchange>>(4);

    ExchangeMutatingWebFilter() {
    }

    public void registerGlobalMutator(UnaryOperator<ServerWebExchange> mutator) {
        Assert.notNull(mutator, (String)"'mutator' is required");
        this.globalMutator = this.globalMutator.andThen(mutator);
    }

    public void registerPerRequestMutator(String requestId, UnaryOperator<ServerWebExchange> mutator) {
        this.perRequestMutators.compute(requestId, (s, value) -> value != null ? value.andThen(mutator) : mutator);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        exchange = this.globalMutator.apply(exchange);
        exchange = this.getMutatorFor(exchange).apply(exchange);
        return chain.filter(exchange);
    }

    private Function<ServerWebExchange, ServerWebExchange> getMutatorFor(ServerWebExchange exchange) {
        String id = WiretapConnector.getRequestId(exchange.getRequest().getHeaders());
        Function<ServerWebExchange, ServerWebExchange> mutator = this.perRequestMutators.remove(id);
        return mutator != null ? mutator : NO_OP_MUTATOR;
    }
}

