/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.reactive.server.WebTestClient;

public class JsonPathAssertions {
    private final WebTestClient.BodyContentSpec bodySpec;
    private final JsonPathExpectationsHelper pathHelper;

    JsonPathAssertions(WebTestClient.BodyContentSpec spec, String expression, Object ... args) {
        this.bodySpec = spec;
        this.pathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public WebTestClient.BodyContentSpec isEqualTo(Object expectedValue) {
        this.bodySpec.consumeAsStringWith(body -> this.pathHelper.assertValue((String)body, expectedValue));
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec exists() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::exists);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec doesNotExist() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::doesNotExist);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isEmpty() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::assertValueIsEmpty);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isNotEmpty() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::assertValueIsNotEmpty);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isBoolean() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::assertValueIsBoolean);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isNumber() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::assertValueIsNumber);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isArray() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::assertValueIsArray);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isMap() {
        this.bodySpec.consumeAsStringWith(this.pathHelper::assertValueIsMap);
        return this.bodySpec;
    }
}

