/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.test.web.reactive.server.AbstractMockServerSpec;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.support.HandlerFunctionAdapter;
import org.springframework.web.reactive.function.server.support.ServerResponseResultHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

public class RouterFunctionSpec
extends AbstractMockServerSpec<RouterFunctionSpec> {
    private final RouterFunction<?> routerFunction;

    RouterFunctionSpec(RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    @Override
    protected WebHttpHandlerBuilder initHttpHandlerBuilder() {
        return WebHttpHandlerBuilder.applicationContext((ApplicationContext)this.initApplicationContext());
    }

    private ApplicationContext initApplicationContext() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.registerBean("webHandler", DispatcherHandler.class, () -> new DispatcherHandler(), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerMapping.class, () -> RouterFunctions.toHandlerMapping(this.routerFunction), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerAdapter.class, () -> new HandlerFunctionAdapter(), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerResultHandler.class, () -> new ServerResponseResultHandler(), new BeanDefinitionCustomizer[0]);
        context.refresh();
        return context;
    }
}

