/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WiretapClientHttpRequest;
import org.springframework.test.web.reactive.server.WiretapClientHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class WiretapConnector
implements ClientHttpConnector {
    public static final String REQUEST_ID_HEADER_NAME = "request-id";
    private final ClientHttpConnector delegate;
    private final Map<String, ExchangeResult> exchanges = new ConcurrentHashMap<String, ExchangeResult>();

    public WiretapConnector(ClientHttpConnector delegate) {
        this.delegate = delegate;
    }

    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        AtomicReference requestRef = new AtomicReference();
        return this.delegate.connect(method, uri, request -> {
            WiretapClientHttpRequest wrapped = new WiretapClientHttpRequest((ClientHttpRequest)request);
            requestRef.set(wrapped);
            return (Mono)requestCallback.apply((ClientHttpRequest)wrapped);
        }).map(response -> {
            WiretapClientHttpRequest wrappedRequest = (WiretapClientHttpRequest)((Object)((Object)requestRef.get()));
            String requestId = WiretapConnector.getRequestId(wrappedRequest.getHeaders());
            Assert.notNull((Object)requestId, (String)"No request-id header");
            WiretapClientHttpResponse wrappedResponse = new WiretapClientHttpResponse((ClientHttpResponse)response);
            ExchangeResult result = new ExchangeResult(wrappedRequest, wrappedResponse);
            this.exchanges.put(requestId, result);
            return wrappedResponse;
        });
    }

    public static String getRequestId(HttpHeaders headers) {
        String requestId = headers.getFirst(REQUEST_ID_HEADER_NAME);
        Assert.notNull((Object)requestId, (String)"No request-id header");
        return requestId;
    }

    public ExchangeResult claimRequest(String requestId) {
        ExchangeResult result = this.exchanges.get(requestId);
        Assert.notNull((Object)result, (String)("No match for request with id [" + requestId + "]"));
        return result;
    }
}

