/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.test.web.servlet.ResultMatcher;
import org.w3c.dom.Node;

public class XpathResultMatchers {
    private final XpathExpectationsHelper xpathHelper;

    protected XpathResultMatchers(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.xpathHelper = new XpathExpectationsHelper(expression, namespaces, args);
    }

    public ResultMatcher node(Matcher<? super Node> matcher) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertNode(response.getContentAsByteArray(), this.getDefinedEncoding(response), matcher);
        };
    }

    private String getDefinedEncoding(MockHttpServletResponse response) {
        return response.isCharset() ? response.getCharacterEncoding() : null;
    }

    public ResultMatcher exists() {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.exists(response.getContentAsByteArray(), this.getDefinedEncoding(response));
        };
    }

    public ResultMatcher doesNotExist() {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.doesNotExist(response.getContentAsByteArray(), this.getDefinedEncoding(response));
        };
    }

    public ResultMatcher nodeCount(Matcher<Integer> matcher) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertNodeCount(response.getContentAsByteArray(), this.getDefinedEncoding(response), matcher);
        };
    }

    public ResultMatcher nodeCount(int expectedCount) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertNodeCount(response.getContentAsByteArray(), this.getDefinedEncoding(response), expectedCount);
        };
    }

    public ResultMatcher string(Matcher<? super String> matcher) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertString(response.getContentAsByteArray(), this.getDefinedEncoding(response), matcher);
        };
    }

    public ResultMatcher string(String expectedValue) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertString(response.getContentAsByteArray(), this.getDefinedEncoding(response), expectedValue);
        };
    }

    public ResultMatcher number(Matcher<? super Double> matcher) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertNumber(response.getContentAsByteArray(), this.getDefinedEncoding(response), matcher);
        };
    }

    public ResultMatcher number(Double expectedValue) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertNumber(response.getContentAsByteArray(), this.getDefinedEncoding(response), expectedValue);
        };
    }

    public ResultMatcher booleanValue(Boolean value) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            this.xpathHelper.assertBoolean(response.getContentAsByteArray(), this.getDefinedEncoding(response), value);
        };
    }
}

