/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import javax.servlet.http.HttpSession;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public class SharedHttpSessionConfigurer
implements MockMvcConfigurer {
    private HttpSession session;

    @Override
    public void afterConfigurerAdded(ConfigurableMockMvcBuilder<?> builder) {
        builder.alwaysDo(result -> {
            this.session = result.getRequest().getSession(false);
        });
    }

    @Override
    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        return request -> {
            if (this.session != null) {
                request.setSession(this.session);
            }
            return request;
        };
    }

    public static SharedHttpSessionConfigurer sharedHttpSession() {
        return new SharedHttpSessionConfigurer();
    }
}

