/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.Part;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

public class MockMultipartHttpServletRequestBuilder
extends MockHttpServletRequestBuilder {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();
    private final MultiValueMap<String, Part> parts = new LinkedMultiValueMap();

    MockMultipartHttpServletRequestBuilder(String urlTemplate, Object ... uriVariables) {
        super(HttpMethod.POST, urlTemplate, uriVariables);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    MockMultipartHttpServletRequestBuilder(URI uri) {
        super(HttpMethod.POST, uri);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public MockMultipartHttpServletRequestBuilder file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return this;
    }

    public MockMultipartHttpServletRequestBuilder file(MockMultipartFile file) {
        this.files.add(file);
        return this;
    }

    public MockMultipartHttpServletRequestBuilder part(Part ... parts) {
        Assert.notEmpty((Object[])parts, (String)"'parts' must not be empty");
        for (Part part : parts) {
            this.parts.add((Object)part.getName(), (Object)part);
        }
        return this;
    }

    @Override
    public Object merge(@Nullable Object parent) {
        if (parent == null) {
            return this;
        }
        if (parent instanceof MockHttpServletRequestBuilder) {
            super.merge(parent);
            if (parent instanceof MockMultipartHttpServletRequestBuilder) {
                MockMultipartHttpServletRequestBuilder parentBuilder = (MockMultipartHttpServletRequestBuilder)parent;
                this.files.addAll(parentBuilder.files);
                parentBuilder.parts.keySet().forEach(name -> {
                    List cfr_ignored_0 = (List)this.parts.putIfAbsent(name, parentBuilder.parts.get(name));
                });
            }
        } else {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        return this;
    }

    @Override
    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request2 = new MockMultipartHttpServletRequest(servletContext);
        this.files.forEach(request2::addFile);
        this.parts.values().stream().flatMap(Collection::stream).forEach(part -> {
            request2.addPart((Part)part);
            try {
                MultipartFile file = this.asMultipartFile((Part)part);
                if (file != null) {
                    request2.addFile(file);
                    return;
                }
                String value = this.toParameterValue((Part)part);
                if (value != null) {
                    request2.addParameter(part.getName(), this.toParameterValue((Part)part));
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to read content for part " + part.getName(), ex);
            }
        });
        return request2;
    }

    @Nullable
    private MultipartFile asMultipartFile(Part part) throws IOException {
        String name = part.getName();
        String filename = part.getSubmittedFileName();
        if (filename != null) {
            return new MockMultipartFile(name, filename, part.getContentType(), part.getInputStream());
        }
        return null;
    }

    @Nullable
    private String toParameterValue(Part part) throws IOException {
        MediaType mediaType;
        String rawType = part.getContentType();
        MediaType mediaType2 = mediaType = rawType != null ? MediaType.parseMediaType((String)rawType) : MediaType.TEXT_PLAIN;
        if (!mediaType.isCompatibleWith(MediaType.TEXT_PLAIN)) {
            return null;
        }
        Charset charset = mediaType.getCharset() != null ? mediaType.getCharset() : StandardCharsets.UTF_8;
        InputStreamReader reader = new InputStreamReader(part.getInputStream(), charset);
        return FileCopyUtils.copyToString((Reader)reader);
    }
}

