/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.util;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.test.context.util.TestContextSpringFactoriesUtils;

class TestContextFailureHandler
implements SpringFactoriesLoader.FailureHandler {
    private final Log logger = LogFactory.getLog(TestContextSpringFactoriesUtils.class);

    TestContextFailureHandler() {
    }

    public void handleFailure(Class<?> factoryType, String factoryImplementationName, Throwable failure) {
        Throwable ex;
        if (failure instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)failure;
            v0 = ite.getTargetException();
        } else {
            v0 = ex = failure;
        }
        if (ex instanceof ClassNotFoundException || ex instanceof NoClassDefFoundError) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Skipping candidate %1$s [%2$s] due to a missing dependency. Specify custom %1$s classes or make the default %1$s classes and their required dependencies available. Offending class: [%3$s]".formatted(factoryType.getSimpleName(), factoryImplementationName, ex.getMessage()));
            }
        } else if (ex instanceof LinkageError) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Could not load %1$s [%2$s]. Specify custom %1$s classes or make the default %1$s classes available.".formatted(factoryType.getSimpleName(), factoryImplementationName), ex);
            }
        } else if (NativeDetector.inNativeImage() && ex instanceof IllegalStateException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Skipping candidate %1$s [%2$s] due to an error when loading it in a native image.".formatted(factoryType.getSimpleName(), factoryImplementationName));
            }
        } else {
            if (ex instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)ex;
                throw runtimeException;
            }
            if (ex instanceof Error) {
                Error error = (Error)ex;
                throw error;
            }
            throw new IllegalStateException("Failed to load %s [%s]".formatted(factoryType.getSimpleName(), factoryImplementationName), ex);
        }
    }
}

