/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.accept.MappingContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;

public abstract class AbstractMappingContentTypeResolver
implements MappingContentTypeResolver {
    private final ConcurrentMap<String, MediaType> mediaTypeLookup = new ConcurrentHashMap<String, MediaType>(64);
    private final MultiValueMap<MediaType, String> keyLookup = new LinkedMultiValueMap(64);

    public AbstractMappingContentTypeResolver(Map<String, MediaType> mediaTypes) {
        if (mediaTypes != null) {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                String extension = entry.getKey().toLowerCase(Locale.ENGLISH);
                MediaType mediaType = entry.getValue();
                this.mediaTypeLookup.put(extension, mediaType);
                this.keyLookup.add((Object)mediaType, (Object)extension);
            }
        }
    }

    protected MediaType getMediaType(String key) {
        return (MediaType)this.mediaTypeLookup.get(key.toLowerCase(Locale.ENGLISH));
    }

    protected List<MediaType> getMediaTypes() {
        return new ArrayList<MediaType>(this.mediaTypeLookup.values());
    }

    @Override
    public List<MediaType> resolveMediaTypes(ServerWebExchange exchange) throws NotAcceptableStatusException {
        String key = this.extractKey(exchange);
        return this.resolveMediaTypes(key);
    }

    public List<MediaType> resolveMediaTypes(String key) throws NotAcceptableStatusException {
        if (StringUtils.hasText((String)key)) {
            MediaType mediaType = this.getMediaType(key);
            if (mediaType != null) {
                this.handleMatch(key, mediaType);
                return Collections.singletonList(mediaType);
            }
            mediaType = this.handleNoMatch(key);
            if (mediaType != null) {
                MediaType previous = this.mediaTypeLookup.putIfAbsent(key, mediaType);
                if (previous == null) {
                    this.keyLookup.add((Object)mediaType, (Object)key);
                }
                return Collections.singletonList(mediaType);
            }
        }
        return Collections.emptyList();
    }

    protected abstract String extractKey(ServerWebExchange var1);

    protected void handleMatch(String key, MediaType mediaType) {
    }

    protected MediaType handleNoMatch(String key) throws NotAcceptableStatusException {
        return null;
    }

    @Override
    public Set<String> getKeysFor(MediaType mediaType) {
        List keys = (List)this.keyLookup.get((Object)mediaType);
        return keys != null ? new HashSet(keys) : Collections.emptySet();
    }

    @Override
    public Set<String> getKeys() {
        return new HashSet<String>(this.mediaTypeLookup.keySet());
    }
}

