/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.Locale;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.accept.AbstractMappingContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriUtils;

public class PathExtensionContentTypeResolver
extends AbstractMappingContentTypeResolver {
    private boolean useJaf = true;
    private boolean ignoreUnknownExtensions = true;

    public PathExtensionContentTypeResolver(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
    }

    public PathExtensionContentTypeResolver() {
        super(null);
    }

    public void setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
    }

    public void setIgnoreUnknownExtensions(boolean ignoreUnknownExtensions) {
        this.ignoreUnknownExtensions = ignoreUnknownExtensions;
    }

    @Override
    protected String extractKey(ServerWebExchange exchange) {
        String path = exchange.getRequest().getURI().getRawPath();
        String extension = UriUtils.extractFileExtension((String)path);
        return StringUtils.hasText((String)extension) ? extension.toLowerCase(Locale.ENGLISH) : null;
    }

    @Override
    protected MediaType handleNoMatch(String key) throws NotAcceptableStatusException {
        MediaType mediaType;
        if (this.useJaf && (mediaType = MediaTypeFactory.getMediaType((String)("file." + key))) != null && !MediaType.APPLICATION_OCTET_STREAM.equals((Object)mediaType)) {
            return mediaType;
        }
        if (!this.ignoreUnknownExtensions) {
            throw new NotAcceptableStatusException(this.getMediaTypes());
        }
        return null;
    }

    public MediaType resolveMediaTypeForResource(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        MediaType mediaType = null;
        String filename = resource.getFilename();
        String extension = StringUtils.getFilenameExtension((String)filename);
        if (extension != null) {
            mediaType = this.getMediaType(extension);
        }
        if (mediaType == null) {
            mediaType = MediaTypeFactory.getMediaType((String)filename);
        }
        if (MediaType.APPLICATION_OCTET_STREAM.equals((Object)mediaType)) {
            mediaType = null;
        }
        return mediaType;
    }
}

