/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.Request;
import org.springframework.web.reactive.function.RouterFunctions;
import org.springframework.web.reactive.function.StrategiesSupplier;
import org.springframework.web.server.ServerWebExchange;

class DefaultRequest
implements Request {
    private final ServerWebExchange exchange;
    private final Request.Headers headers;
    private final StrategiesSupplier strategies;

    DefaultRequest(ServerWebExchange exchange, StrategiesSupplier strategies) {
        this.exchange = exchange;
        this.strategies = strategies;
        this.headers = new DefaultHeaders();
    }

    @Override
    public HttpMethod method() {
        return this.request().getMethod();
    }

    @Override
    public URI uri() {
        return this.request().getURI();
    }

    @Override
    public Request.Headers headers() {
        return this.headers;
    }

    @Override
    public <T> T body(BodyExtractor<T> extractor) {
        return extractor.extract(this.request(), this.strategies);
    }

    @Override
    public <T> Optional<T> attribute(String name) {
        return this.exchange.getAttribute(name);
    }

    @Override
    public List<String> queryParams(String name) {
        List<String> queryParams = (List<String>)this.request().getQueryParams().get((Object)name);
        return queryParams != null ? queryParams : Collections.emptyList();
    }

    @Override
    public Map<String, String> pathVariables() {
        return this.exchange.getAttribute(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE).orElseGet(Collections::emptyMap);
    }

    private ServerHttpRequest request() {
        return this.exchange.getRequest();
    }

    ServerWebExchange exchange() {
        return this.exchange;
    }

    private class DefaultHeaders
    implements Request.Headers {
        private DefaultHeaders() {
        }

        private HttpHeaders delegate() {
            return DefaultRequest.this.request().getHeaders();
        }

        @Override
        public List<MediaType> accept() {
            return this.delegate().getAccept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.delegate().getAcceptCharset();
        }

        @Override
        public OptionalLong contentLength() {
            long value = this.delegate().getContentLength();
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate().getContentType());
        }

        @Override
        public InetSocketAddress host() {
            return this.delegate().getHost();
        }

        @Override
        public List<HttpRange> range() {
            return this.delegate().getRange();
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate().get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.delegate());
        }
    }
}

