/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.Conventions;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.Rendering;
import org.springframework.web.reactive.function.Response;
import org.springframework.web.reactive.function.StrategiesSupplier;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultResponseBuilder
implements Response.BodyBuilder {
    private final int statusCode;
    private final HttpHeaders headers = new HttpHeaders();

    public DefaultResponseBuilder(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public Response.BodyBuilder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public Response.BodyBuilder headers(HttpHeaders headers) {
        if (headers != null) {
            this.headers.putAll((Map)headers);
        }
        return this;
    }

    @Override
    public Response.BodyBuilder allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public Response.BodyBuilder contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public Response.BodyBuilder contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public Response.BodyBuilder eTag(String eTag) {
        if (eTag != null) {
            if (!eTag.startsWith("\"") && !eTag.startsWith("W/\"")) {
                eTag = "\"" + eTag;
            }
            if (!eTag.endsWith("\"")) {
                eTag = eTag + "\"";
            }
        }
        this.headers.setETag(eTag);
        return this;
    }

    @Override
    public Response.BodyBuilder lastModified(ZonedDateTime lastModified) {
        ZonedDateTime gmt = lastModified.withZoneSameInstant(ZoneId.of("GMT"));
        String headerValue = DateTimeFormatter.RFC_1123_DATE_TIME.format(gmt);
        this.headers.set("Last-Modified", headerValue);
        return this;
    }

    @Override
    public Response.BodyBuilder location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public Response.BodyBuilder cacheControl(CacheControl cacheControl) {
        String ccValue = cacheControl.getHeaderValue();
        if (ccValue != null) {
            this.headers.setCacheControl(cacheControl.getHeaderValue());
        }
        return this;
    }

    @Override
    public Response.BodyBuilder varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public Response<Void> build() {
        return this.body(BodyInserter.of((response, strategies) -> response.setComplete(), () -> null));
    }

    @Override
    public <T extends Publisher<Void>> Response<T> build(T voidPublisher) {
        Assert.notNull(voidPublisher, (String)"'voidPublisher' must not be null");
        return this.body(BodyInserter.of((response, strategies) -> Flux.from((Publisher)voidPublisher).then((Publisher)response.setComplete()), () -> null));
    }

    @Override
    public <T> Response<T> body(BiFunction<ServerHttpResponse, StrategiesSupplier, Mono<Void>> writer, Supplier<T> supplier) {
        return this.body(BodyInserter.of(writer, supplier));
    }

    @Override
    public <T> Response<T> body(BodyInserter<T> inserter) {
        Assert.notNull(inserter, (String)"'inserter' must not be null");
        return new BodyInserterResponse<T>(this.statusCode, this.headers, inserter);
    }

    @Override
    public Response<Rendering> render(String name, Object ... modelAttributes) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        return this.render(name, DefaultResponseBuilder.toModelMap(modelAttributes));
    }

    private static Map<String, Object> toModelMap(Object[] modelAttributes) {
        if (!ObjectUtils.isEmpty((Object[])modelAttributes)) {
            return Arrays.stream(modelAttributes).filter(o -> !DefaultResponseBuilder.isEmptyCollection(o)).collect(Collectors.toMap(Conventions::getVariableName, o -> o));
        }
        return null;
    }

    private static boolean isEmptyCollection(Object o) {
        return o instanceof Collection && ((Collection)o).isEmpty();
    }

    @Override
    public Response<Rendering> render(String name, Map<String, ?> model) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        LinkedHashMap<String, Object> modelMap = new LinkedHashMap<String, Object>();
        if (model != null) {
            modelMap.putAll(model);
        }
        return new RenderingResponse(this.statusCode, this.headers, name, modelMap);
    }

    private static final class RenderingResponse
    extends AbstractResponse<Rendering> {
        private final String name;
        private final Map<String, Object> model;
        private final Rendering rendering;

        public RenderingResponse(int statusCode, HttpHeaders headers, String name, Map<String, Object> model) {
            super(statusCode, headers);
            this.name = name;
            this.model = model;
            this.rendering = new DefaultRendering();
        }

        @Override
        public Rendering body() {
            return this.rendering;
        }

        @Override
        public Mono<Void> writeTo(ServerWebExchange exchange, StrategiesSupplier strategies) {
            ServerHttpResponse response = exchange.getResponse();
            this.writeStatusAndHeaders(response);
            MediaType contentType = exchange.getResponse().getHeaders().getContentType();
            Locale locale = Locale.ENGLISH;
            Stream<ViewResolver> viewResolverStream = strategies.viewResolvers().get();
            return Flux.fromStream(viewResolverStream).concatMap(viewResolver -> viewResolver.resolveViewName(this.name, locale)).next().otherwiseIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Could not resolve view with name '" + this.name + "'"))).then(view -> view.render(this.model, contentType, exchange));
        }

        private class DefaultRendering
        implements Rendering {
            private DefaultRendering() {
            }

            @Override
            public String name() {
                return RenderingResponse.this.name;
            }

            @Override
            public Map<String, Object> model() {
                return RenderingResponse.this.model;
            }
        }
    }

    private static final class BodyInserterResponse<T>
    extends AbstractResponse<T> {
        private final BodyInserter<T> inserter;

        public BodyInserterResponse(int statusCode, HttpHeaders headers, BodyInserter<T> inserter) {
            super(statusCode, headers);
            this.inserter = inserter;
        }

        @Override
        public T body() {
            return this.inserter.t();
        }

        @Override
        public Mono<Void> writeTo(ServerWebExchange exchange, StrategiesSupplier strategies) {
            ServerHttpResponse response = exchange.getResponse();
            this.writeStatusAndHeaders(response);
            return this.inserter.insert(response, strategies);
        }
    }

    private static abstract class AbstractResponse<T>
    implements Response<T> {
        private final int statusCode;
        private final HttpHeaders headers;

        protected AbstractResponse(int statusCode, HttpHeaders headers) {
            this.statusCode = statusCode;
            this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
        }

        @Override
        public final HttpStatus statusCode() {
            return HttpStatus.valueOf((int)this.statusCode);
        }

        @Override
        public final HttpHeaders headers() {
            return this.headers;
        }

        protected void writeStatusAndHeaders(ServerHttpResponse response) {
            response.setStatusCode(HttpStatus.valueOf((int)this.statusCode));
            HttpHeaders responseHeaders = response.getHeaders();
            if (!this.headers.isEmpty()) {
                this.headers.entrySet().stream().filter(entry -> !responseHeaders.containsKey(entry.getKey())).forEach(entry -> responseHeaders.put((String)entry.getKey(), (List)entry.getValue()));
            }
        }
    }
}

