/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import org.springframework.util.Assert;
import org.springframework.web.reactive.function.Request;

@FunctionalInterface
public interface RequestPredicate {
    public boolean test(Request var1);

    default public RequestPredicate and(final RequestPredicate other) {
        Assert.notNull((Object)other, (String)"'other' must not be null");
        return new RequestPredicate(){

            @Override
            public boolean test(Request t) {
                return RequestPredicate.this.test(t) && other.test(t);
            }

            @Override
            public Request subRequest(Request request) {
                return other.subRequest(RequestPredicate.this.subRequest(request));
            }
        };
    }

    default public RequestPredicate negate() {
        return t -> !this.test(t);
    }

    default public RequestPredicate or(RequestPredicate other) {
        Assert.notNull((Object)other, (String)"'other' must not be null");
        return t -> this.test(t) || other.test(t);
    }

    default public Request subRequest(Request request) {
        return request;
    }
}

