/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Map;
import java.util.Optional;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.function.DefaultRequest;
import org.springframework.web.reactive.function.HandlerFunction;
import org.springframework.web.reactive.function.Request;
import org.springframework.web.reactive.function.RequestPredicate;
import org.springframework.web.reactive.function.Response;
import org.springframework.web.reactive.function.RouterFunction;
import org.springframework.web.reactive.function.StrategiesSupplier;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import reactor.core.publisher.Mono;

public abstract class RouterFunctions {
    public static final String REQUEST_ATTRIBUTE = RouterFunctions.class.getName() + ".request";
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = RouterFunctions.class.getName() + ".uriTemplateVariables";
    private static final HandlerFunction<Void> NOT_FOUND_HANDLER = request -> Response.notFound().build();

    public static <T> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(handlerFunction, (String)"'handlerFunction' must not be null");
        return request -> predicate.test(request) ? Optional.of(handlerFunction) : Optional.empty();
    }

    public static <T> RouterFunction<T> subroute(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(routerFunction, (String)"'routerFunction' must not be null");
        return request -> {
            if (predicate.test(request)) {
                Request subRequest = predicate.subRequest(request);
                return routerFunction.route(subRequest);
            }
            return Optional.empty();
        };
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHttpHandler(routerFunction, StrategiesSupplier.withDefaults());
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction, StrategiesSupplier strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"StrategiesSupplier must not be null");
        return new HttpWebHandlerAdapter(exchange -> {
            DefaultRequest request = new DefaultRequest(exchange, strategies);
            RouterFunctions.addAttributes(exchange, request);
            HandlerFunction handlerFunction = routerFunction.route(request).orElse(RouterFunctions.notFound());
            Response response = handlerFunction.handle(request);
            return response.writeTo(exchange, strategies);
        });
    }

    public static HandlerMapping toHandlerMapping(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHandlerMapping(routerFunction, StrategiesSupplier.withDefaults());
    }

    public static HandlerMapping toHandlerMapping(RouterFunction<?> routerFunction, StrategiesSupplier strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"StrategiesSupplier must not be null");
        return exchange -> {
            DefaultRequest request = new DefaultRequest(exchange, strategies);
            RouterFunctions.addAttributes(exchange, request);
            Optional route = routerFunction.route(request);
            return Mono.justOrEmpty(route);
        };
    }

    private static void addAttributes(ServerWebExchange exchange, Request request) {
        Map attributes = exchange.getAttributes();
        attributes.put(REQUEST_ATTRIBUTE, request);
    }

    private static <T> HandlerFunction<T> notFound() {
        return NOT_FOUND_HANDLER;
    }

    static <T> HandlerFunction<T> cast(HandlerFunction<?> handlerFunction) {
        return handlerFunction;
    }
}

