/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.support;

import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.function.Response;
import org.springframework.web.reactive.function.StrategiesSupplier;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponseResultHandler
implements HandlerResultHandler {
    private final StrategiesSupplier strategies;

    public ResponseResultHandler() {
        this(StrategiesSupplier.builder().build());
    }

    public ResponseResultHandler(StrategiesSupplier strategies) {
        Assert.notNull((Object)strategies, (String)"'strategies' must not be null");
        this.strategies = strategies;
    }

    @Override
    public boolean supports(HandlerResult result) {
        return result.getReturnValue().filter(o -> o instanceof Response).isPresent();
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Response response = (Response)result.getReturnValue().orElseThrow(IllegalStateException::new);
        return response.writeTo(exchange, this.strategies);
    }
}

