/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.http.HttpCookie;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class CookieValueMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public CookieValueMethodArgumentResolver(ConversionService conversionService, ConfigurableBeanFactory beanFactory) {
        super(conversionService, beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(CookieValue.class);
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        CookieValue annotation = (CookieValue)parameter.getParameterAnnotation(CookieValue.class);
        return new CookieValueNamedValueInfo(annotation);
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange) {
        HttpCookie cookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)name);
        if (HttpCookie.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return Mono.justOrEmpty((Object)cookie);
        }
        if (cookie != null) {
            return Mono.justOrEmpty((Object)cookie.getValue());
        }
        return Mono.empty();
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        String type = parameter.getNestedParameterType().getSimpleName();
        String reason = "Missing cookie '" + name + "' for method parameter of type " + type;
        throw new ServerWebInputException(reason, parameter);
    }

    private static class CookieValueNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private CookieValueNamedValueInfo(CookieValue annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

