/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class PathVariableMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public PathVariableMethodArgumentResolver(ConversionService conversionService, ConfigurableBeanFactory beanFactory) {
        super(conversionService, beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (!parameter.hasParameterAnnotation(PathVariable.class)) {
            return false;
        }
        if (Map.class.isAssignableFrom(parameter.nestedIfOptional().getNestedParameterType())) {
            String paramName = ((PathVariable)parameter.getParameterAnnotation(PathVariable.class)).value();
            return StringUtils.hasText((String)paramName);
        }
        return true;
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        PathVariable annotation = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        return new PathVariableNamedValueInfo(annotation);
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange) {
        String attributeName = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        Optional optional = exchange.getAttribute(attributeName);
        Object value = null;
        if (optional.isPresent()) {
            value = ((Map)optional.get()).get(name);
        }
        return Mono.justOrEmpty(value);
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new ServerErrorException(name, parameter);
    }

    @Override
    protected void handleResolvedValue(Object arg, String name, MethodParameter parameter, ModelMap model, ServerWebExchange exchange) {
    }

    private static class PathVariableNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        public PathVariableNamedValueInfo(PathVariable annotation) {
            super(annotation.name(), annotation.required(), "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }
    }
}

