/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageWriterResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponseEntityResultHandler
extends AbstractMessageWriterResultHandler
implements HandlerResultHandler {
    private static final List<HttpMethod> SAFE_METHODS = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD);

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        this(messageWriters, contentTypeResolver, new ReactiveAdapterRegistry());
    }

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(messageWriters, contentTypeResolver, adapterRegistry);
        this.setOrder(0);
    }

    @Override
    public boolean supports(HandlerResult result) {
        Class returnType = result.getReturnType().getRawClass();
        if (this.isSupportedType(returnType)) {
            return true;
        }
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(returnType, result.getReturnValue());
        if (adapter != null && !adapter.getDescriptor().isMultiValue() && !adapter.getDescriptor().isNoValue()) {
            ResolvableType genericType = result.getReturnType().getGeneric(new int[]{0});
            return this.isSupportedType(genericType.getRawClass());
        }
        return false;
    }

    private boolean isSupportedType(Class<?> clazz) {
        return HttpEntity.class.isAssignableFrom(clazz) && !RequestEntity.class.isAssignableFrom(clazz);
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        MethodParameter bodyType;
        Mono returnValueMono;
        ResolvableType returnType = result.getReturnType();
        Optional<Object> optionalValue = result.getReturnValue();
        Class rawClass = returnType.getRawClass();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapterFrom(rawClass, optionalValue);
        if (adapter != null) {
            returnValueMono = adapter.toMono(optionalValue);
            bodyType = new MethodParameter(result.getReturnTypeSource());
            bodyType.increaseNestingLevel();
            bodyType.increaseNestingLevel();
        } else {
            returnValueMono = Mono.justOrEmpty(optionalValue);
            bodyType = new MethodParameter(result.getReturnTypeSource());
            bodyType.increaseNestingLevel();
        }
        return returnValueMono.then(returnValue -> {
            Assert.isInstanceOf(HttpEntity.class, (Object)returnValue);
            HttpEntity httpEntity = (HttpEntity)returnValue;
            if (httpEntity instanceof ResponseEntity) {
                ResponseEntity responseEntity = (ResponseEntity)httpEntity;
                exchange.getResponse().setStatusCode(responseEntity.getStatusCode());
            }
            HttpHeaders entityHeaders = httpEntity.getHeaders();
            HttpHeaders responseHeaders = exchange.getResponse().getHeaders();
            if (!entityHeaders.isEmpty()) {
                entityHeaders.entrySet().stream().filter(entry -> !responseHeaders.containsKey(entry.getKey())).forEach(entry -> responseHeaders.put((String)entry.getKey(), (List)entry.getValue()));
            }
            if (httpEntity.getBody() == null) {
                exchange.getResponse().setComplete();
                return Mono.empty();
            }
            String etag = entityHeaders.getETag();
            Instant lastModified = Instant.ofEpochMilli(entityHeaders.getLastModified());
            HttpMethod httpMethod = exchange.getRequest().getMethod();
            if (SAFE_METHODS.contains(httpMethod) && exchange.checkNotModified(etag, lastModified)) {
                exchange.getResponse().setComplete();
                return Mono.empty();
            }
            return this.writeBody(httpEntity.getBody(), bodyType, exchange);
        });
    }
}

