/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.ui.ModelMap;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class ServerWebExchangeArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return ServerWebExchange.class.isAssignableFrom(paramType) || ServerHttpRequest.class.isAssignableFrom(paramType) || ServerHttpResponse.class.isAssignableFrom(paramType) || WebSession.class.isAssignableFrom(paramType) || HttpMethod.class == paramType;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, ModelMap model, ServerWebExchange exchange) {
        Class paramType = parameter.getParameterType();
        if (ServerWebExchange.class.isAssignableFrom(paramType)) {
            return Mono.just((Object)exchange);
        }
        if (ServerHttpRequest.class.isAssignableFrom(paramType)) {
            return Mono.just((Object)exchange.getRequest());
        }
        if (ServerHttpResponse.class.isAssignableFrom(paramType)) {
            return Mono.just((Object)exchange.getResponse());
        }
        if (WebSession.class.isAssignableFrom(paramType)) {
            return exchange.getSession().cast(Object.class);
        }
        if (HttpMethod.class == paramType) {
            return Mono.just((Object)exchange.getRequest().getMethod());
        }
        return Mono.error((Throwable)new UnsupportedOperationException("Unknown parameter type: " + paramType + " in method: " + parameter.getMethod()));
    }
}

