/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.reactive.BindingContext;
import reactor.core.publisher.Mono;

public class HandlerResult {
    private final Object handler;
    private final Object returnValue;
    private final ResolvableType returnType;
    private final BindingContext bindingContext;
    private Function<Throwable, Mono<HandlerResult>> exceptionHandler;

    public HandlerResult(Object handler, Object returnValue, MethodParameter returnType) {
        this(handler, returnValue, returnType, null);
    }

    public HandlerResult(Object handler, Object returnValue, MethodParameter returnType, BindingContext context) {
        Assert.notNull((Object)handler, (String)"'handler' is required");
        Assert.notNull((Object)returnType, (String)"'returnType' is required");
        this.handler = handler;
        this.returnValue = returnValue;
        this.returnType = ResolvableType.forMethodParameter((MethodParameter)returnType);
        this.bindingContext = context != null ? context : new BindingContext();
    }

    public Object getHandler() {
        return this.handler;
    }

    public Optional<Object> getReturnValue() {
        return Optional.ofNullable(this.returnValue);
    }

    public ResolvableType getReturnType() {
        return this.returnType;
    }

    public MethodParameter getReturnTypeSource() {
        return (MethodParameter)this.returnType.getSource();
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public Model getModel() {
        return this.bindingContext.getModel();
    }

    public HandlerResult setExceptionHandler(Function<Throwable, Mono<HandlerResult>> function) {
        this.exceptionHandler = function;
        return this;
    }

    public boolean hasExceptionHandler() {
        return this.exceptionHandler != null;
    }

    public Mono<HandlerResult> applyExceptionHandler(Throwable failure) {
        return this.hasExceptionHandler() ? this.exceptionHandler.apply(failure) : Mono.error((Throwable)failure);
    }
}

