/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.DefaultClientRequestBuilder;
import org.springframework.web.reactive.function.client.WebClientStrategies;
import org.springframework.web.util.DefaultUriTemplateHandler;
import reactor.core.publisher.Mono;

public interface ClientRequest<T> {
    public HttpMethod method();

    public URI url();

    public HttpHeaders headers();

    public MultiValueMap<String, String> cookies();

    public BodyInserter<T, ? super ClientHttpRequest> inserter();

    public Mono<Void> writeTo(ClientHttpRequest var1, WebClientStrategies var2);

    public static BodyBuilder from(ClientRequest<?> other) {
        Assert.notNull(other, (String)"'other' must not be null");
        return (BodyBuilder)new DefaultClientRequestBuilder(other.method(), other.url()).headers(other.headers()).cookies(other.cookies());
    }

    public static BodyBuilder method(HttpMethod method, URI url) {
        return new DefaultClientRequestBuilder(method, url);
    }

    public static BodyBuilder method(HttpMethod method, String urlTemplate, Object ... uriVariables) {
        DefaultUriTemplateHandler templateHandler = new DefaultUriTemplateHandler();
        URI url = templateHandler.expand(urlTemplate, uriVariables);
        return new DefaultClientRequestBuilder(method, url);
    }

    public static HeadersBuilder<?> GET(String urlTemplate, Object ... uriVariables) {
        return ClientRequest.method(HttpMethod.GET, urlTemplate, uriVariables);
    }

    public static HeadersBuilder<?> HEAD(String urlTemplate, Object ... uriVariables) {
        return ClientRequest.method(HttpMethod.HEAD, urlTemplate, uriVariables);
    }

    public static BodyBuilder POST(String urlTemplate, Object ... uriVariables) {
        return ClientRequest.method(HttpMethod.POST, urlTemplate, uriVariables);
    }

    public static BodyBuilder PUT(String urlTemplate, Object ... uriVariables) {
        return ClientRequest.method(HttpMethod.PUT, urlTemplate, uriVariables);
    }

    public static BodyBuilder PATCH(String urlTemplate, Object ... uriVariables) {
        return ClientRequest.method(HttpMethod.PATCH, urlTemplate, uriVariables);
    }

    public static HeadersBuilder<?> DELETE(String urlTemplate, Object ... uriVariables) {
        return ClientRequest.method(HttpMethod.DELETE, urlTemplate, uriVariables);
    }

    public static HeadersBuilder<?> OPTIONS(String urlTemplate, Object ... uriVariables) {
        return ClientRequest.method(HttpMethod.OPTIONS, urlTemplate, uriVariables);
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public <T> ClientRequest<T> body(BodyInserter<T, ? super ClientHttpRequest> var1);

        public <T, S extends Publisher<T>> ClientRequest<S> body(S var1, Class<T> var2);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(HttpHeaders var1);

        public B accept(MediaType ... var1);

        public B acceptCharset(Charset ... var1);

        public B ifModifiedSince(ZonedDateTime var1);

        public B ifNoneMatch(String ... var1);

        public B cookie(String var1, String var2);

        public B cookies(MultiValueMap<String, String> var1);

        public ClientRequest<Void> build();
    }
}

