/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.logging.Level;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientStrategies;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

class DefaultWebClientBuilder
implements WebClient.Builder {
    private ClientHttpConnector clientHttpConnector;
    private WebClientStrategies strategies = WebClientStrategies.withDefaults();
    private ExchangeFilterFunction filter = new NoOpFilter();

    public DefaultWebClientBuilder(ClientHttpConnector clientHttpConnector) {
        this.clientHttpConnector = clientHttpConnector;
    }

    @Override
    public WebClient.Builder strategies(WebClientStrategies strategies) {
        Assert.notNull((Object)strategies, (String)"'strategies' must not be null");
        this.strategies = strategies;
        return this;
    }

    @Override
    public WebClient.Builder filter(ExchangeFilterFunction filter) {
        Assert.notNull((Object)filter, (String)"'filter' must not be null");
        this.filter = filter.andThen(this.filter);
        return this;
    }

    @Override
    public WebClient build() {
        return new DefaultWebClient(this.clientHttpConnector, this.strategies, this.filter);
    }

    private class NoOpFilter
    implements ExchangeFilterFunction {
        private NoOpFilter() {
        }

        @Override
        public Mono<ClientResponse> filter(ClientRequest<?> request, ExchangeFunction next) {
            return next.exchange(request);
        }
    }

    private static final class DefaultWebClient
    implements WebClient {
        private final ClientHttpConnector clientHttpConnector;
        private final WebClientStrategies strategies;
        private final ExchangeFilterFunction filter;

        public DefaultWebClient(ClientHttpConnector clientHttpConnector, WebClientStrategies strategies, ExchangeFilterFunction filter) {
            this.clientHttpConnector = clientHttpConnector;
            this.strategies = strategies;
            this.filter = filter;
        }

        @Override
        public Mono<ClientResponse> exchange(ClientRequest<?> request) {
            Assert.notNull(request, (String)"'request' must not be null");
            return this.filter.filter(request, this::exchangeInternal);
        }

        private Mono<ClientResponse> exchangeInternal(ClientRequest<?> request) {
            return this.clientHttpConnector.connect(request.method(), request.url(), clientHttpRequest -> request.writeTo((ClientHttpRequest)clientHttpRequest, this.strategies)).log("org.springframework.web.client.reactive", Level.FINE, new SignalType[0]).map(clientHttpResponse -> new DefaultClientResponse((ClientHttpResponse)clientHttpResponse, this.strategies));
        }

        @Override
        public WebClient filter(ExchangeFilterFunction filter) {
            Assert.notNull((Object)filter, (String)"'filter' must not be null");
            ExchangeFilterFunction composedFilter = filter.andThen(this.filter);
            return new DefaultWebClient(this.clientHttpConnector, this.strategies, composedFilter);
        }
    }
}

