/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import reactor.core.publisher.Mono;

public abstract class ExchangeFilterFunctions {
    public static ExchangeFilterFunction basicAuthentication(String username, String password) {
        Assert.notNull((Object)username, (String)"'username' must not be null");
        Assert.notNull((Object)password, (String)"'password' must not be null");
        return ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            String authorization = ExchangeFilterFunctions.authorization(username, password);
            ClientRequest authorizedRequest = ((ClientRequest.BodyBuilder)ClientRequest.from(clientRequest).header("Authorization", authorization)).body(clientRequest.inserter());
            return Mono.just(authorizedRequest);
        });
    }

    private static String authorization(String username, String password) {
        String credentials = username + ":" + password;
        byte[] credentialBytes = credentials.getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodedBytes = Base64.getEncoder().encode(credentialBytes);
        String encodedCredentials = new String(encodedBytes, StandardCharsets.ISO_8859_1);
        return "Basic " + encodedCredentials;
    }
}

