/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultWebClientBuilder;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClientStrategies;
import reactor.core.publisher.Mono;

public interface WebClient
extends ExchangeFunction {
    @Override
    public Mono<ClientResponse> exchange(ClientRequest<?> var1);

    public WebClient filter(ExchangeFilterFunction var1);

    public static WebClient create(ClientHttpConnector connector) {
        return WebClient.builder(connector).build();
    }

    public static Builder builder(ClientHttpConnector connector) {
        Assert.notNull((Object)connector, (String)"'connector' must not be null");
        return new DefaultWebClientBuilder(connector);
    }

    public static interface Builder {
        public Builder strategies(WebClientStrategies var1);

        public Builder filter(ExchangeFilterFunction var1);

        public WebClient build();
    }
}

