/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.DefaultWebClientStrategiesBuilder;

public interface WebClientStrategies {
    public Supplier<Stream<HttpMessageReader<?>>> messageReaders();

    public Supplier<Stream<HttpMessageWriter<?>>> messageWriters();

    public static WebClientStrategies withDefaults() {
        return WebClientStrategies.builder().build();
    }

    public static WebClientStrategies of(ApplicationContext applicationContext) {
        return WebClientStrategies.builder(applicationContext).build();
    }

    public static WebClientStrategies of(final Supplier<Stream<HttpMessageReader<?>>> messageReaders, final Supplier<Stream<HttpMessageWriter<?>>> messageWriters) {
        return new WebClientStrategies(){

            @Override
            public Supplier<Stream<HttpMessageReader<?>>> messageReaders() {
                return this.checkForNull(messageReaders);
            }

            @Override
            public Supplier<Stream<HttpMessageWriter<?>>> messageWriters() {
                return this.checkForNull(messageWriters);
            }

            private <T> Supplier<Stream<T>> checkForNull(Supplier<Stream<T>> supplier) {
                return supplier != null ? supplier : Stream::empty;
            }
        };
    }

    public static Builder builder() {
        DefaultWebClientStrategiesBuilder builder = new DefaultWebClientStrategiesBuilder();
        builder.defaultConfiguration();
        return builder;
    }

    public static Builder builder(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        DefaultWebClientStrategiesBuilder builder = new DefaultWebClientStrategiesBuilder();
        builder.applicationContext(applicationContext);
        return builder;
    }

    public static Builder empty() {
        return new DefaultWebClientStrategiesBuilder();
    }

    public static interface Builder {
        public Builder messageReader(HttpMessageReader<?> var1);

        public Builder decoder(Decoder<?> var1);

        public Builder messageWriter(HttpMessageWriter<?> var1);

        public Builder encoder(Encoder<?> var1);

        public WebClientStrategies build();
    }
}

