/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.ByteBufferEncoder;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.result.view.ViewResolver;

class DefaultHandlerStrategiesBuilder
implements HandlerStrategies.Builder {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)DefaultHandlerStrategiesBuilder.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)DefaultHandlerStrategiesBuilder.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)DefaultHandlerStrategiesBuilder.class.getClassLoader());
    private final List<HttpMessageReader<?>> messageReaders = new ArrayList();
    private final List<HttpMessageWriter<?>> messageWriters = new ArrayList();
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>();

    DefaultHandlerStrategiesBuilder() {
    }

    public void defaultConfiguration() {
        this.messageReader((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ByteArrayDecoder()));
        this.messageReader((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new ByteBufferDecoder()));
        this.messageReader((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new StringDecoder()));
        this.messageWriter((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new ByteArrayEncoder()));
        this.messageWriter((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new ByteBufferEncoder()));
        this.messageWriter((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new CharSequenceEncoder()));
        this.messageWriter((HttpMessageWriter<?>)new ResourceHttpMessageWriter());
        if (jaxb2Present) {
            this.messageReader((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new Jaxb2XmlDecoder()));
            this.messageWriter((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)new Jaxb2XmlEncoder()));
        }
        if (jackson2Present) {
            this.messageReader((HttpMessageReader<?>)new DecoderHttpMessageReader((Decoder)new Jackson2JsonDecoder()));
            Jackson2JsonEncoder jsonEncoder = new Jackson2JsonEncoder();
            this.messageWriter((HttpMessageWriter<?>)new EncoderHttpMessageWriter((Encoder)jsonEncoder));
            this.messageWriter((HttpMessageWriter<?>)new ServerSentEventHttpMessageWriter(Collections.singletonList(jsonEncoder)));
        } else {
            this.messageWriter((HttpMessageWriter<?>)new ServerSentEventHttpMessageWriter());
        }
    }

    public void applicationContext(ApplicationContext applicationContext) {
        applicationContext.getBeansOfType(HttpMessageReader.class).values().forEach(this::messageReader);
        applicationContext.getBeansOfType(HttpMessageWriter.class).values().forEach(this::messageWriter);
        applicationContext.getBeansOfType(ViewResolver.class).values().forEach(this::viewResolver);
    }

    @Override
    public HandlerStrategies.Builder messageReader(HttpMessageReader<?> messageReader) {
        Assert.notNull(messageReader, (String)"'messageReader' must not be null");
        this.messageReaders.add(messageReader);
        return this;
    }

    @Override
    public HandlerStrategies.Builder messageWriter(HttpMessageWriter<?> messageWriter) {
        Assert.notNull(messageWriter, (String)"'messageWriter' must not be null");
        this.messageWriters.add(messageWriter);
        return this;
    }

    @Override
    public HandlerStrategies.Builder viewResolver(ViewResolver viewResolver) {
        Assert.notNull((Object)viewResolver, (String)"'viewResolver' must not be null");
        this.viewResolvers.add(viewResolver);
        return this;
    }

    @Override
    public HandlerStrategies build() {
        return new DefaultHandlerStrategies(this.messageReaders, this.messageWriters, this.viewResolvers);
    }

    private static class DefaultHandlerStrategies
    implements HandlerStrategies {
        private final List<HttpMessageReader<?>> messageReaders;
        private final List<HttpMessageWriter<?>> messageWriters;
        private final List<ViewResolver> viewResolvers;

        public DefaultHandlerStrategies(List<HttpMessageReader<?>> messageReaders, List<HttpMessageWriter<?>> messageWriters, List<ViewResolver> viewResolvers) {
            this.messageReaders = DefaultHandlerStrategies.unmodifiableCopy(messageReaders);
            this.messageWriters = DefaultHandlerStrategies.unmodifiableCopy(messageWriters);
            this.viewResolvers = DefaultHandlerStrategies.unmodifiableCopy(viewResolvers);
        }

        private static <T> List<T> unmodifiableCopy(List<? extends T> list) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }

        @Override
        public Supplier<Stream<HttpMessageReader<?>>> messageReaders() {
            return this.messageReaders::stream;
        }

        @Override
        public Supplier<Stream<HttpMessageWriter<?>>> messageWriters() {
            return this.messageWriters::stream;
        }

        @Override
        public Supplier<Stream<ViewResolver>> viewResolvers() {
            return this.viewResolvers::stream;
        }
    }
}

