/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.util.UriUtils;
import reactor.core.publisher.Mono;

class PathResourceLookupFunction
implements Function<ServerRequest, Mono<Resource>> {
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    private final String pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        this.pattern = pattern;
        this.location = location;
    }

    @Override
    public Mono<Resource> apply(ServerRequest request) {
        String path = PathResourceLookupFunction.processPath(request.path());
        if (path.contains("%")) {
            path = UriUtils.decode((String)path, (Charset)StandardCharsets.UTF_8);
        }
        if (!StringUtils.hasLength((String)path) || PathResourceLookupFunction.isInvalidPath(path)) {
            return Mono.empty();
        }
        if (!PATH_MATCHER.match(this.pattern, path)) {
            return Mono.empty();
        }
        path = PATH_MATCHER.extractPathWithinPattern(this.pattern, path);
        try {
            Resource resource = this.location.createRelative(path);
            if (resource.exists() && resource.isReadable() && this.isResourceUnderLocation(resource)) {
                return Mono.just((Object)resource);
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static String processPath(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            path = slash ? "/" + path.substring(i) : path.substring(i);
            return path;
        }
        return slash ? "/" : "";
    }

    private static boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                return true;
            }
        }
        return path.contains("") && (path = StringUtils.cleanPath((String)path)).contains("../");
    }

    private boolean isResourceUnderLocation(Resource resource) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != this.location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)this.location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)this.location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)this.location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        String string = locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        if (!resourcePath.startsWith(locationPath)) {
            return false;
        }
        return !resourcePath.contains("%") || !UriUtils.decode((String)resourcePath, (String)"UTF-8").contains("../");
    }
}

