/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PathResourceResolver
extends AbstractResourceResolver {
    private Resource[] allowedLocations;

    public void setAllowedLocations(Resource ... locations) {
        this.allowedLocations = locations;
    }

    public Resource[] getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, locations);
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String path, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (StringUtils.hasText((String)path)) {
            return this.getResource(path, locations).map(resource -> path);
        }
        return Mono.empty();
    }

    private Mono<Resource> getResource(String resourcePath, List<? extends Resource> locations) {
        return Flux.fromIterable(locations).concatMap(location -> this.getResource(resourcePath, (Resource)location)).next();
    }

    protected Mono<Resource> getResource(String resourcePath, Resource location) {
        try {
            Resource resource = location.createRelative(resourcePath);
            if (resource.exists() && resource.isReadable()) {
                if (this.checkResource(resource, location)) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Found match: " + resource));
                    }
                    return Mono.just((Object)resource);
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Resource path=\"" + resourcePath + "\" was successfully resolved but resource=\"" + resource.getURL() + "\" is neither under the current location=\"" + location.getURL() + "\" nor under any of the allowed locations=" + Arrays.asList(this.getAllowedLocations())));
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No match for location: " + location));
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Failure checking for relative resource under location + " + location), (Throwable)ex);
            }
            return Mono.error((Throwable)ex);
        }
    }

    protected boolean checkResource(Resource resource, Resource location) throws IOException {
        if (this.isResourceUnderLocation(resource, location)) {
            return true;
        }
        if (this.getAllowedLocations() != null) {
            for (Resource current : this.getAllowedLocations()) {
                if (!this.isResourceUnderLocation(resource, current)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isResourceUnderLocation(Resource resource, Resource location) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        String string = locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        if (!resourcePath.startsWith(locationPath)) {
            return false;
        }
        if (resourcePath.contains("%") && URLDecoder.decode(resourcePath, "UTF-8").contains("../")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Resolved resource path contains \"../\" after decoding: " + resourcePath));
            }
            return false;
        }
        return true;
    }
}

