/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ContentVersionStrategy;
import org.springframework.web.reactive.resource.FixedVersionStrategy;
import org.springframework.web.reactive.resource.HttpResource;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.VersionStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class VersionResourceResolver
extends AbstractResourceResolver {
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, VersionStrategy> versionStrategyMap = new LinkedHashMap<String, VersionStrategy>();

    public void setStrategyMap(Map<String, VersionStrategy> map) {
        this.versionStrategyMap.clear();
        this.versionStrategyMap.putAll(map);
    }

    public Map<String, VersionStrategy> getStrategyMap() {
        return this.versionStrategyMap;
    }

    public VersionResourceResolver addContentVersionStrategy(String ... pathPatterns) {
        this.addVersionStrategy(new ContentVersionStrategy(), pathPatterns);
        return this;
    }

    public VersionResourceResolver addFixedVersionStrategy(String version, String ... pathPatterns) {
        List<String> patternsList = Arrays.asList(pathPatterns);
        ArrayList<String> prefixedPatterns = new ArrayList<String>(pathPatterns.length);
        String versionPrefix = "/" + version;
        for (String pattern : patternsList) {
            prefixedPatterns.add(pattern);
            if (pattern.startsWith(versionPrefix) || patternsList.contains(versionPrefix + pattern)) continue;
            prefixedPatterns.add(versionPrefix + pattern);
        }
        return this.addVersionStrategy(new FixedVersionStrategy(version), prefixedPatterns.toArray(new String[0]));
    }

    public VersionResourceResolver addVersionStrategy(VersionStrategy strategy, String ... pathPatterns) {
        for (String pattern : pathPatterns) {
            this.getStrategyMap().put(pattern, strategy);
        }
        return this;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveResource(exchange, requestPath, locations).otherwiseIfEmpty(Mono.defer(() -> this.resolveVersionedResource(exchange, requestPath, locations, chain)));
    }

    private Mono<Resource> resolveVersionedResource(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        VersionStrategy versionStrategy = this.getStrategyForPath(requestPath);
        if (versionStrategy == null) {
            return Mono.empty();
        }
        String candidateVersion = versionStrategy.extractVersion(requestPath);
        if (StringUtils.isEmpty((Object)candidateVersion)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No version found in path \"" + requestPath + "\""));
            }
            return Mono.empty();
        }
        String simplePath = versionStrategy.removeVersion(requestPath, candidateVersion);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Extracted version from path, re-resolving without version: \"" + simplePath + "\""));
        }
        return chain.resolveResource(exchange, simplePath, locations).then(baseResource -> {
            String actualVersion = versionStrategy.getResourceVersion((Resource)baseResource);
            if (candidateVersion.equals(actualVersion)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Resource matches extracted version [" + candidateVersion + "]"));
                }
                return Mono.just((Object)new FileNameVersionedResource((Resource)baseResource, candidateVersion));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Potential resource found for \"" + requestPath + "\", but version [" + candidateVersion + "] does not match"));
            }
            return Mono.empty();
        });
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations).then(baseUrl -> {
            if (StringUtils.hasText((String)baseUrl)) {
                VersionStrategy versionStrategy = this.getStrategyForPath(resourceUrlPath);
                if (versionStrategy == null) {
                    return Mono.empty();
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Getting the original resource to determine version for path \"" + resourceUrlPath + "\""));
                }
                return chain.resolveResource(null, (String)baseUrl, locations).map(resource -> {
                    String version = versionStrategy.getResourceVersion((Resource)resource);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Determined version [" + version + "] for " + resource));
                    }
                    return versionStrategy.addVersion((String)baseUrl, version);
                });
            }
            return Mono.empty();
        });
    }

    protected VersionStrategy getStrategyForPath(String requestPath) {
        String path = "/".concat(requestPath);
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.versionStrategyMap.keySet()) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator comparator = this.pathMatcher.getPatternComparator(path);
            Collections.sort(matchingPatterns, comparator);
            return this.versionStrategyMap.get(matchingPatterns.get(0));
        }
        return null;
    }

    private class FileNameVersionedResource
    extends AbstractResource
    implements HttpResource {
        private final Resource original;
        private final String version;

        public FileNameVersionedResource(Resource original, String version) {
            this.original = original;
            this.version = version;
        }

        public boolean exists() {
            return this.original.exists();
        }

        public boolean isReadable() {
            return this.original.isReadable();
        }

        public boolean isOpen() {
            return this.original.isOpen();
        }

        public boolean isFile() {
            return this.original.isFile();
        }

        public URL getURL() throws IOException {
            return this.original.getURL();
        }

        public URI getURI() throws IOException {
            return this.original.getURI();
        }

        public File getFile() throws IOException {
            return this.original.getFile();
        }

        public String getFilename() {
            return this.original.getFilename();
        }

        public long contentLength() throws IOException {
            return this.original.contentLength();
        }

        public long lastModified() throws IOException {
            return this.original.lastModified();
        }

        public Resource createRelative(String relativePath) throws IOException {
            return this.original.createRelative(relativePath);
        }

        public String getDescription() {
            return this.original.getDescription();
        }

        public InputStream getInputStream() throws IOException {
            return this.original.getInputStream();
        }

        @Override
        public HttpHeaders getResponseHeaders() {
            HttpHeaders headers = this.original instanceof HttpResource ? ((HttpResource)this.original).getResponseHeaders() : new HttpHeaders();
            headers.setETag("\"" + this.version + "\"");
            return headers;
        }
    }
}

