/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import org.webjars.MultipleMatchesException;
import org.webjars.WebJarAssetLocator;
import reactor.core.publisher.Mono;

public class WebJarsResourceResolver
extends AbstractResourceResolver {
    private static final String WEBJARS_LOCATION = "META-INF/resources/webjars/";
    private static final int WEBJARS_LOCATION_LENGTH = "META-INF/resources/webjars/".length();
    private final WebJarAssetLocator webJarAssetLocator;

    public WebJarsResourceResolver() {
        this(new WebJarAssetLocator());
    }

    public WebJarsResourceResolver(WebJarAssetLocator webJarAssetLocator) {
        this.webJarAssetLocator = webJarAssetLocator;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveResource(exchange, requestPath, locations).otherwiseIfEmpty(Mono.defer(() -> {
            String webJarsResourcePath = this.findWebJarResourcePath(requestPath);
            if (webJarsResourcePath != null) {
                return chain.resolveResource(exchange, webJarsResourcePath, locations);
            }
            return Mono.empty();
        }));
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations).otherwiseIfEmpty(Mono.defer(() -> {
            String webJarResourcePath = this.findWebJarResourcePath(resourceUrlPath);
            if (webJarResourcePath != null) {
                return chain.resolveUrlPath(webJarResourcePath, locations);
            }
            return Mono.empty();
        }));
    }

    protected String findWebJarResourcePath(String path) {
        block5: {
            try {
                int startOffset = path.startsWith("/") ? 1 : 0;
                int endOffset = path.indexOf("/", 1);
                if (endOffset != -1) {
                    String webjar = path.substring(startOffset, endOffset);
                    String partialPath = path.substring(endOffset);
                    String webJarPath = this.webJarAssetLocator.getFullPath(webjar, partialPath);
                    return webJarPath.substring(WEBJARS_LOCATION_LENGTH);
                }
            }
            catch (MultipleMatchesException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("WebJar version conflict for \"" + path + "\""), (Throwable)ex);
                }
            }
            catch (IllegalArgumentException ex) {
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace((Object)("No WebJar resource found for \"" + path + "\""));
            }
        }
        return null;
    }
}

